package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.param.stock.RollbackOccupyStockParam;

/**
 * 活动库存remote接口
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/17 10:27 下午
 * @since 0.0.1
 **/
@AdvancedFeignClient
public interface RemoteActivityStockService {
    /**
     * 退还预占库存
     *
     * @param rollbackOccupyStockParam 退还预占库存请求参数
     * @return true/false
     * @throws BizException 业务异常
     *                      <ul>
     *                          <li>通过活动id:[{}]无法查到活动信息</li>
     *                          <li>活动未结束，无法返还库存</li>
     *                          <li>库存正在操作，无法返还</li>
     *                      </ul>
     */
    Boolean rollbackOccupyStock(RollbackOccupyStockParam rollbackOccupyStockParam) throws BizException;

    /**
     * 已过期奖品返还
     *
     * @param userId   租户id
     * @param userType 用户类型
     * @return true/false
     * @throws BizException 业务异常
     *                      <ul>
     *                          <li>请求参数有误</li>
     *                          <li>库存正在操作，无法返还</li>
     *                      </ul>
     */
    Boolean rollbackPrizeStock(Long userId, Integer userType) throws BizException;

    /**
     * 回退已过期奖品
     * @param activityId 活动id
     * @param userId 租户id
     * @param userType 用户类型
     * @return
     * @throws BizException 业务异常
     *                      <ul>
     *                          <li>请求参数有误</li>
     *                          <li>过期奖品库存正在操作，无法返还</li>
     *                      </ul>
     */
    Boolean rollbackExpiredPrizeStock(Long activityId, Long userId, Integer userType) throws BizException;
}