package cn.com.duiba.zhongyan.activity.service.api.remoteservice.travel;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivitySignDetailRecordDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.travel.IndexTagDto;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.travel.TravelVoteInfoDto;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.travel.VoteTravelDto;
import cn.com.duiba.zhongyan.activity.service.api.param.travel.RemoteSubmitSignParam;
import cn.com.duiba.zhongyan.activity.service.api.param.travel.RemoteSubmitTravelParam;

import java.util.List;

/**
 * @author duiba
 */
@AdvancedFeignClient
public interface RemoteTravelService {


    VoteTravelDto voteIndex(Long activityId, Long userId) throws BizException;


    TravelVoteInfoDto getTravelVoteInfo(Long activityId, Integer id, Long userId) throws BizException;


    Long submitTravelVote(RemoteSubmitTravelParam remoteSubmitTravelParam) throws BizException;
    Long submitSign(RemoteSubmitSignParam remoteSubmitSignParam) throws BizException;

    /**
     * 根据活动ID和用户ID查询签到记录
     *
     * @param activityId
     * @param userId
     * @return
     */
    List<ActivitySignDetailRecordDTO> listByActivityIdAndUserId(Long activityId, Long userId);

    /**
     * 根据活动id分页查询（按照id升序）
     * @param activityId 活动id
     * @param lastId 上一页最后的id（可为null）
     * @param pageSize 每页多少条
     * @param pageNo 第几页（从1开始）
     * @return
     */
    List<ActivitySignDetailRecordDTO> pageQueryByActivityId(long activityId, Long lastId, long pageSize, long pageNo);

    IndexTagDto getTravelTagVoteInfo(Long activityId, Long userId, String cityCode) throws BizException;


}
