package cn.com.duiba.zhongyan.activity.service.api.utils.question;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.utils.Conditions;
import cn.com.duiba.zhongyan.activity.service.api.enums.CommonStateEnum;
import cn.com.duiba.zhongyan.activity.service.api.enums.QuestionTypeEnum;
import cn.com.duiba.zhongyan.activity.service.api.param.AnswerParam;
import cn.com.duiba.zhongyan.activity.service.api.param.OptionParam;
import cn.com.duiba.zhongyan.activity.service.api.param.QuestionAnswerParam;
import cn.hutool.extra.emoji.EmojiUtil;
import org.apache.commons.lang3.StringUtils;

/**
 * 单选题校验处理
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/9
 */
public class SingleChoiceHandler extends AbstractQuestionAnswerCheckHandler {

    @Override
    public QuestionTypeEnum getType() {
        return QuestionTypeEnum.SINGLE_CHOICE;
    }

    @Override
    void specificQuestionCheck(QuestionAnswerParam param) throws BizException {
        commonChoiceQuestionCheck(param, 10);
    }

    @Override
    String specificAnswerCheck(QuestionAnswerParam param, AnswerCheckContext context) throws BizException {
        Integer questionId = param.getQuestionId();
        // 1. 单选题只能有一个答案
        Conditions.expectTrue(param.getAnswerList().size() == 1, "题目["+ questionId +"]:答案错误-单选题只能选择一个答案");
        // 2. 答案要在题目里面
        checkOptionParam(param.getOption(), questionId,10);
        AnswerParam answer = param.getAnswerList().get(0);
        Conditions.expectTrue(StringUtils.isNotBlank(answer.getAnswer()), "题目["+ questionId +"]:答案错误-答案不能为空");

        OptionParam option = param.getOption().stream().filter(opt -> answer.getAnswer().equals(opt.getOptionId())).findFirst().orElse(null);
        Conditions.expectNotNull(option, "题目["+ questionId +"]:答案错误-答案不在选项中");
        // 3. 是否要校验必填框
        if (CommonStateEnum.STATE_ZERO.getState().equals(option.getAllowWrite())
                && CommonStateEnum.STATE_ZERO.getState().equals(option.getTipStatus())) {
            Conditions.expectTrue(StringUtils.isNotBlank(answer.getRequiredAnswer()), "题目["+ questionId +"]:答案错误-填空框不能为空");
        }
        if (StringUtils.isNotBlank(answer.getRequiredAnswer())) {
            Conditions.expectTrue(EmojiUtil.removeAllEmojis(answer.getRequiredAnswer()).length() <= 50, "题目["+ questionId +"]:答案错误-填空框不能超过50个字符");
            return answer.getRequiredAnswer();
        }
        return EMPTY_STRING;
    }

}
