/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.zhongyan.activity.service.api.remoteservice.statistics;

import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import java.util.Objects;

public interface CheatCenterStatisticsConfig {
    public static final String TOTAL_CHEAT_ALL_PV = "cheat_all_pv";
    public static final String CHEAT_BLACK_PV = "cheat_black_pv";
    public static final String CHEAT_GREY_PV = "cheat_grey_pv";
    public static final String CHEAT_BLACK_DAY_PV = "cheat_black_pv_%s";
    public static final String CHEAT_GREY_DAY_PV = "cheat_grey_pv_%s";

    public static String getTotalCheatAllPv() {
        return TOTAL_CHEAT_ALL_PV;
    }

    public static String getCheatBlackPv() {
        return CHEAT_BLACK_PV;
    }

    public static String getCheatGreyPv() {
        return CHEAT_GREY_PV;
    }

    public static String getCheatBlackDayPv(Date day) {
        if (Objects.isNull(day)) {
            day = new Date();
        }
        int dayNumber = DateUtils.getDayNumber((Date)day);
        return String.format(CHEAT_BLACK_DAY_PV, dayNumber);
    }

    public static String getCheatGreyDayPv(Date day) {
        if (Objects.isNull(day)) {
            day = new Date();
        }
        int dayNumber = DateUtils.getDayNumber((Date)day);
        return String.format(CHEAT_GREY_DAY_PV, dayNumber);
    }
}

