package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.entity.PageResponse;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.record.*;
import cn.com.duiba.zhongyan.activity.service.api.param.*;
import cn.com.duiba.zhongyan.activity.service.api.param.record.RemoteChangePointParam;
import cn.com.duiba.zhongyan.activity.service.api.param.record.RemoteFindPointParam;
import cn.com.duiba.zhongyan.activity.service.api.param.record.RemoteGetDataDailyParam;
import cn.com.duiba.zhongyan.activity.service.api.param.record.RemotePointRecordBindLinkParam;
import cn.com.duiba.zhongyan.activity.service.api.param.record.RemoteQueryPointParam;
import cn.com.duiba.zhongyan.activity.service.api.param.record.RemoteScanCodePageListParam;
import cn.com.duiba.zhongyan.activity.service.api.param.record.RemoteScanCodeParam;
import cn.com.duiba.zhongyan.activity.service.api.param.record.RemoteScanProductPageParam;

import java.util.List;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/3/17
 */
@AdvancedFeignClient
public interface RemoteActivityUserPointService {

    /**
     * 扫码操作
     *
     * @param param
     * @return 记录id
     */
    Long codeScan(RemoteScanCodeParam param);

    /**
     * 查找记录列表
     *
     * @param param
     * @return
     */
    PageResponse<ActivityUserPointRecordDto> queryRecordList(RemoteQueryPointParam param);

    /**
     * 查找单独记录
     *
     * @param recordId
     * @return
     */
    ActivityUserPointRecordDto getByRecordId(Long recordId);


    /**
     * 更新记录
     *
     * @param remotePointRecordBindLinkParam
     * @return
     */
    Boolean updateLink(RemotePointRecordBindLinkParam remotePointRecordBindLinkParam);


    /**
     * 获取积分账户信息
     *
     * @param remoteFindPointParam
     * @return
     */
    ActivityUserPointDto findPoint(RemoteFindPointParam remoteFindPointParam);


    /**
     * 根据条件查询记录
     *
     * @param remoteQueryPointParam
     * @return
     */
    List<ActivityUserPointRecordDto> findRecordByCondition(RemoteQueryPointParam remoteQueryPointParam);

    /**
     * 根据条件查询记录(数量)
     *
     * @param remoteQueryPointParam
     * @return
     */
    Integer findRecordCountByCondition(RemoteQueryPointParam remoteQueryPointParam);


    /**
     * 查询用户详细积分记录列表
     * @param param
     * @return
     */
    PageResponse<ScanCodePageRecordDto> queryAllUserRecordList(RemoteScanCodePageListParam param);

    /**
     * 修改积分
     * @param param
     * @return 增加记录id
     */
     Long changePoint(RemoteChangePointParam param) throws BizException;


    /**
     * 创建品规配置
     * @param activityScanProductDto
     * @return
     */
    Long createScanProduct(ActivityScanProductDto activityScanProductDto);

    /**
     * 更新品规
     * @param activityScanProductDto
     * @return
     */
    Boolean updateScanProduct(ActivityScanProductDto activityScanProductDto);


    /**
     * 查询品规列表
     * @param param
     * @return
     */
    PageResponse<ActivityScanProductDto> pageScanProduct(RemoteScanProductPageParam param);

    /**
     * 根据活动id获取datav数据
     * @param activityId
     * @return
     */
    ActivityScanDataVDto getDataVByActivityId(Long activityId);

    /**
     * 根据活动id获取dataV日常数据
     * @param param
     * @return
     */
    List<ActivityScanDataVDailyDto> getDataDailyByActivityId(RemoteGetDataDailyParam param);

    /**
     * 根据品规编码查找品规信息
     * @param productList
     * @return
     */
    List<ActivityScanProductDto> queryByProduct(List<String> productList);


    /**
     * 修改积分 对没有用户积分的体系用户进行初始化用户积分
     * @param param
     * @return 增加记录id
     */
    Long changUserPoint(RemoteChangePointParam param) throws BizException;

    /**
     * 查询积分明细记录(创建时间倒序)
     * @param queryCreditDetailRecordListParam 查询参数
     * @return 列表
     */
    PageResponse<ActivityUserPointRecordDto> queryCreditDetailRecordList(QueryCreditDetailRecordListParam queryCreditDetailRecordListParam);


    /**
     * 查询最近积分明细记录列表
     * @param queryPointPageParam
     * @return
     */
    List<ActivityUserPointDetailRecordDto> queryLastUserPointRecordList(QueryPointPageParam queryPointPageParam);

    /**
     * 根据活动id分页
     * @param queryActivityUserPointPageParam 分页查询参数
     * @return 活动下的用户积分数据
     */
    PageResponse<ActivityUserPointDto> getUserPointListByActivityId(QueryActivityUserPointPageParam queryActivityUserPointPageParam);

    /**
     * 根据积分账户id和时间范围批量查询用户积分记录
     * @param batchQueryActivityUserPointParam 积分账户id
     * @return 用户积分记录
     */
    List<ActivityUserPointRecordDto> batchQueryActivityUserPointByPointIdsTime(BatchQueryActivityUserPointParam batchQueryActivityUserPointParam);

    /**
     * 查询消耗获得的积分数 根据活动id
     * @param queryPointPageParam
     * @return
     */
    ActivityUserPointCountDto queryUserPointCountByActivityId(QueryPointPageParam queryPointPageParam);

    /**
     * 根据活动TYPE 统计数据
     * @param activityChangeTypeCountParam
     * @return
     */
   List<ActivityTaskByTypeCountDto> queryTypeCountByActivityId(ActivityChangeTypeCountParam activityChangeTypeCountParam);
    /**
     * 获取参与抽奖的人数/次数
     */

    Long getActivityDrawCount(ActivityDrawCountParam activityDrawCountParam);

    /**
     * 获取参与 pv
     * @param activityDrawCountParam
     * @return
     */

    Integer  getUserJoinPvByPointRecord(ActivityDrawCountParam activityDrawCountParam);

    /**
     * 获取参与 pv
     * @param activityDrawCountParam
     * @return
     */
    Integer getUserJoinUvByPointRecord(ActivityDrawCountParam activityDrawCountParam);

    /**
     * 获取去重以后的
     * 任务数  ActivityDrawCountParam 作为通用参数 内容自行添加
     */
    List<ActivityTaskByTypeCountDto> getDistinctTaskCount(ActivityDrawCountParam activityDrawCountParam);

}
