/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.zhongyan.activity.service.api.utils.question;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.utils.Conditions;
import cn.com.duiba.zhongyan.activity.service.api.enums.CommonStateEnum;
import cn.com.duiba.zhongyan.activity.service.api.enums.QuestionTypeEnum;
import cn.com.duiba.zhongyan.activity.service.api.param.AnswerParam;
import cn.com.duiba.zhongyan.activity.service.api.param.OptionParam;
import cn.com.duiba.zhongyan.activity.service.api.param.QuestionAnswerParam;
import cn.com.duiba.zhongyan.activity.service.api.utils.question.AbstractQuestionAnswerCheckHandler;
import cn.hutool.extra.emoji.EmojiUtil;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MultipleChoiceHandler
extends AbstractQuestionAnswerCheckHandler {
    @Override
    public QuestionTypeEnum getType() {
        return QuestionTypeEnum.MULTIPLE_CHOICE;
    }

    @Override
    void specificQuestionCheck(QuestionAnswerParam param) throws BizException {
        this.commonChoiceQuestionCheck(param, 10);
    }

    @Override
    String specificAnswerCheck(QuestionAnswerParam param) throws BizException {
        Integer questionId = param.getQuestionId();
        this.checkOptionParam(param.getOption(), questionId, 10);
        Map optionMap = param.getOption().stream().collect(Collectors.toMap(OptionParam::getOptionId, Function.identity()));
        StringBuilder userInput = new StringBuilder();
        for (AnswerParam answer : param.getAnswerList()) {
            Conditions.expectTrue((boolean)StringUtils.isNotBlank((CharSequence)answer.getAnswer()), (String)("\u9898\u76ee[" + questionId + "]:\u7b54\u6848\u9519\u8bef-\u7b54\u6848\u4e0d\u80fd\u4e3a\u7a7a"));
            OptionParam option = (OptionParam)optionMap.get(answer.getAnswer());
            Conditions.expectNotNull((Object)option, (String)("\u9898\u76ee[" + questionId + "]:\u7b54\u6848\u9519\u8bef-\u7b54\u6848\u4e0d\u5728\u9009\u9879\u4e2d"));
            if (CommonStateEnum.STATE_ZERO.getState().equals(option.getAllowWrite()) && CommonStateEnum.STATE_ZERO.getState().equals(option.getTipStatus())) {
                Conditions.expectTrue((boolean)StringUtils.isNotBlank((CharSequence)answer.getRequiredAnswer()), (String)("\u9898\u76ee[" + questionId + "]:\u7b54\u6848\u9519\u8bef-\u586b\u7a7a\u6846\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (!StringUtils.isNotBlank((CharSequence)answer.getRequiredAnswer())) continue;
            Conditions.expectTrue((EmojiUtil.removeAllEmojis((String)answer.getRequiredAnswer()).length() <= 50 ? 1 : 0) != 0, (String)("\u9898\u76ee[" + questionId + "]:\u7b54\u6848\u9519\u8bef-\u586b\u7a7a\u6846\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26"));
            userInput.append(answer.getRequiredAnswer());
        }
        return userInput.toString();
    }
}

