package cn.com.duiba.zhongyan.activity.service.api.enums.record;

/**
 * @author wangxukai
 * @description tb_user_prize_record
 * @date ：Created in 2022/3/18
 */

public enum PrizeRecordTypeEnum {

    /**
     *
     */
    DEFAULT(-1,"未知"),
    PRIZE(1,"中奖"),
    EXCHANGE(2,"兑奖"),

    IMPORT(3, "导入的数据"),

    RECEIVE(4,"领奖")
    ;

    private Integer type;

    private String desc;
    PrizeRecordTypeEnum(Integer type, String desc){
        this.type = type;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getType() {
        return type;
    }

    public static PrizeRecordTypeEnum getByType(Integer type){
        for(PrizeRecordTypeEnum changeTypeEnum : PrizeRecordTypeEnum.values()){
            if(changeTypeEnum.getType().equals(type)){
                return changeTypeEnum;
            }
        }
        return PrizeRecordTypeEnum.DEFAULT;
    }
}
