package cn.com.duiba.zhongyan.activity.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.enums.VerificationSceneEnum;
import cn.com.duiba.zhongyan.activity.service.api.param.SendVerificationParam;

/**
 * @Description 短信验证码相关
 * @Author dangcang
 * @Date 2022/3/11 10:32 上午
 **/
@AdvancedFeignClient
public interface RemoteSmsVerificationService {

    /**
     * 查看是否在发送间隔之内
     * @param key userId
     * @param scene
     * @return 间隔秒数
     * @throws BizException
     */
    Long sendMessageInterval(String key, VerificationSceneEnum scene) throws BizException;

    /**
     * 短信验证码校验
     * @param key
     * @param value
     * @param scene
     * @return
     * @throws BizException
     */
    Boolean verification(String key, String value, VerificationSceneEnum scene) throws BizException;

    /**
     * 发送短信验证码
     * 短信模板仅支持缓存5分钟
     * 同时发送间隔1分钟
     * @param param
     * @return 对应的验证码
     * @throws BizException
     */
    String sendMessage(SendVerificationParam param) throws BizException;
}