package cn.com.duiba.cloud.manage.service.api.model.param.tag;

import lombok.Getter;
import lombok.Setter;
import org.jetbrains.annotations.NotNull;

import javax.validation.constraints.NotBlank;

/**
 * 功能描述：编辑标签参数
 *
 * @Auther: xiaotian
 * @Date: 2021/11/24 10:45
 * @Description:
 *
 */
@Getter
@Setter
public class RemoteTagEditParam {

    /**
     * 标签ID
     */
    @NotNull(value = "id不能为空")
    private Long id;

    /**
     * 标签名称
     */
    @NotBlank(message = "标签名称不能为空")
    private String tagName;

    /**
     * 标签组ID
     */
    @NotNull(value = "标签组不能为空")
    private Long tagGroupId;

    /**
     * 标签类型 1：微信标签 2：本地标签
     */
    @NotNull(value = "标签类型不能为空")
    private Integer tagType;

    /**
     * 标签描述
     */
    private String tagDesc;

}
