package cn.com.duiba.cloud.manage.service.api.remoteservice.singlesign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * @author xuanhongjian
 */
@AdvancedFeignClient
public interface RemoteRedisService {

    Boolean delete(String key);

    String get(String key);

    void increment(String key, long delta);

    void expire(String key, long timeout, TimeUnit timeUnit);

    Boolean setIfAbsent(String key, String value, long timeout, TimeUnit timeUnit);

    Long zsetRemove(String key, Object...values);

    Long zsetAdd(String key, String...values);

    Set<String> members(String key);

    List<String> multiGet(Collection<String> keys);

    Long getExpire(String key);
}
