package cn.com.duiba.cloud.manage.service.api.remoteservice.singlesign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.single.sign.on.domain.params.SendMessageParam;
import cn.com.duiba.cloud.single.sign.on.domain.params.VerificationCodeParam;
import cn.com.duiba.cloud.single.sign.on.domain.response.SendMessageVO;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 发送短信
 *
 * @author xuanhongjian
 */
@AdvancedFeignClient
public interface RemoteSendMessageService {

    /**
     * 发送短信请求
     * @param request 请求体
     * @return 短信唯一id
     */
    SendMessageVO sendMessage(SendMessageParam request);

    /**
     * 校验验证码
     * @param param 验证码
     * @return 校验结果
     */
    Boolean verificationCode(VerificationCodeParam param);


    /**
     * 获取验证码过期时间
     * @param request 请求体
     * @return 下次短信可发送时间
     */
    Long getExpire(@RequestBody @Valid SendMessageParam request);
}
