package cn.com.duiba.cloud.manage.service.api.remoteservice.tag;


import cn.com.duiba.cloud.manage.service.api.model.dto.tag.TagDto;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.RemoteBatchTagUserParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.RemoteTagAddParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.RemoteTagDeleteParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.RemoteTagEditParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.RemoteTagGroupAddParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.RemoteTagGroupDeleteParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.RemoteTagGroupListParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.RemoteTagListParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 功能描述：标签管理
 *
 * @Auther: xiaotian
 * @Date: 2021/11/24 17:46
 * @Description:
 */
public interface RemoteTagService {

    /**
     * 获取标签列表
     *
     * @param tagListParam 筛选参数
     * @return
     */
    PageResponse<TagDto> getTagList(RemoteTagListParam tagListParam);


    /**
     * 获取标签组列表
     *
     * @param tagGroupListParam 筛选参数
     * @return
     */
    PageResponse<TagDto> getTagGroupList(RemoteTagGroupListParam tagGroupListParam);


    /**
     * 新增标签
     *
     * @param param 新增标签属性
     * @return
     */
    Long addTag(RemoteTagAddParam param);


    /**
     * 编辑标签
     *
     * @param param 编辑标签属性
     * @return
     */
    Boolean editTag(RemoteTagEditParam param);

    /**
     * 新增标签组
     *
     * @param param 新增标签组属性
     * @return
     */
    Long addTagGroup(RemoteTagGroupAddParam param);


    /**
     * 删除标签
     *
     * @param id 标签id
     * @return
     */
    Boolean delTag(RemoteTagDeleteParam id);


    /**
     * 删除标签组
     *
     * @param id 标签组id
     * @return
     */
    Boolean delTagGroup(RemoteTagGroupDeleteParam id);


    /**
     * 用户打标签
     *
     * @param batchTagUserParam 打标签参数
     * @return
     */
    Boolean batchTagUser(RemoteBatchTagUserParam batchTagUserParam);


    /**
     * 用户移除标签
     *
     * @param batchTagUserParam 移除标签参数
     * @return
     */
    Boolean batchUnTagUser(RemoteBatchTagUserParam batchTagUserParam);

}
