package cn.com.duiba.cloud.single.sign.on.domain.params;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.io.Serializable;

/**
 * 用户登录参数
 *
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class LoginParam implements Serializable {

    private static final long serialVersionUID = -2372224125142248454L;

    @NotBlank(message = "员工编号不能为空")
    private String userId;

    @Pattern(regexp = "^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,16}$", message = "密码格式不正确")
    private String password;
}
