package cn.com.duiba.cloud.single.sign.on.domain.params;

import cn.com.duiba.cloud.single.sign.on.enums.MessageTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class SendMessageParam {

    /**
     * 消息类型
     * @see MessageTypeEnum
     */
    @NotNull(message = "消息类型不能为空")
    private Integer messageType;

    /**
     * 手机号
     */
    @Pattern(regexp = "^1[0-9]{10}$", message = "手机号格式不正确")
    private String phone;
}
