package cn.com.duiba.cloud.single.sign.on.domain.pojo;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

/**
 * 已注册到sso系统的应用
 *
 * @author xuanhongjian
 */
@Data
@Builder
public class RegisteredApp implements Serializable {

    private String homeUrl;
    private String indexAddress;
    private String outLoginAddress;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RegisteredApp app = (RegisteredApp) o;
        return homeUrl.equals(app.homeUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(homeUrl);
    }
}
