package cn.com.duiba.cloud.single.sign.on.enums;

import com.google.common.collect.ImmutableMap;

import java.util.Objects;

/**
 * @author xuanhongjian 验证码类型
 */
public enum MessageTypeEnum {
  /**
   * 短信模版类型
   */
  RETRIEVE_PASSWORD(0L, "找回密码", 1,"【兑吧集团】您本次操作的验证码为：{0}，5分钟内输入有效，请勿泄漏给他人以免造成损失。"),
  REGISTER(0L, "注册", 2,"【兑吧集团】您本次操作的验证码为：{0}，5分钟内输入有效，请勿泄漏给他人以免造成损失。"),
  MODIFY_MOBILE_PHONE_NUMBER(0L, "修改手机号", 3,"【兑吧集团】您本次操作的验证码为：{0}，5分钟内输入有效，请勿泄漏给他人以免造成损失。"),
  THREE_TIMES_LOGIN_ERROR(0L, "连续登录错误三次", 4,"【兑吧集团】您的账号已连续登录失败多次，如有盗号风险请及时前往修改密码。"),
  FIVE_TIMES_LOGIN_ERROR(0L, "连续登录错误五次", 5,"【兑吧集团】您的账号因多次输错密码已被锁定，请找回密码后再尝试登录。"),
  UNKNOWN_TYPE(0L, "未知类型", 6,"");

  private static final ImmutableMap<Integer, MessageTypeEnum> INNER_MAP;

  static {
    ImmutableMap.Builder<Integer, MessageTypeEnum> builder = ImmutableMap.builder();
    for (MessageTypeEnum item : MessageTypeEnum.values()) {
      builder = builder.put(item.code, item);
    }
    INNER_MAP = builder.build();
  }


  private final Long templateId;
  private final String messageTypeName;
  private final Integer code;



  private final String messageTemplate;

  MessageTypeEnum(Long templateId, String messageTypeName, Integer code,String messageTemplate) {
    this.templateId = templateId;
    this.messageTypeName = messageTypeName;
    this.code = code;
    this.messageTemplate = messageTemplate;
  }

  public static MessageTypeEnum getByCode(Integer termValue) {
    return Objects.isNull(INNER_MAP.get(termValue)) ? MessageTypeEnum.UNKNOWN_TYPE
               : INNER_MAP.get(termValue);
  }

  public Long getTemplateId() {
    return templateId;
  }

  public String getMessageTypeName() {
    return messageTypeName;
  }

  public Integer getCode() {
    return code;
  }

  public String getMessageTemplate() {
    return messageTemplate;
  }
}
