package cn.com.duiba.cloud.single.sign.on.enums;

/**
 * @author xuanhongjian
 */
public enum SsoErrorEnum {
    /**
     * 异常信息
     */
    VERIFICATION_FAILED("登录信息验证失败"),
    USER_NOT_EXIST("手机号未注册"),
    PASSWORD_WRONG("密码错误"),
    USER_FREEZE("账号已被锁定，请稍后尝试或找回密码"),
    TOO_MANY_SESSIONS("会话创建太多"),
    INVALID_TICKET("无效的登录令牌"),
    ERROR_MESSAGE_TYPE("短信类型错误"),
    VERIFICATION_CODE_ERROR("验证码错误"),
    VERIFICATION_CODE_INVALID("验证码失效"),
    THREE_TIME_FAIL("连续失败5次账号会被锁定24小时，请谨慎操作或找回密码"),
    FIVE_TIME_FAIL("账号已被锁定，请稍后尝试或找回密码"),
    TRY_LATER("请稍后重试")
    ;

    private final String message;

    SsoErrorEnum(String message) {
        this.message = message;
    }


    public String getCode() {
        return name();
    }

    public String getMessage() {
        return message;
    }
}
