package cn.com.duiba.cloud.manage.service.api.config;

import cn.com.duiba.cloud.manage.service.api.handler.DataMaskingHandler;
import cn.com.duiba.cloud.manage.service.api.handler.DataSecretHandler;
import cn.com.duiba.cloud.manage.service.api.interceptor.DataMaskingClassInterceptor;
import cn.com.duiba.cloud.manage.service.api.interceptor.DataSecretClassInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @program: duiba-manage-service
 * @description: 项目Web配置
 * @author: 郭云龙
 * @create: 2021-11-25 16:10
 **/
@Configuration
public class WebAppConfig implements WebMvcConfigurer {

    // SpringMVC 需要手动添加拦截器
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        DataMaskingClassInterceptor interceptor = new DataMaskingClassInterceptor();
        registry.addInterceptor(interceptor);
        registry.addInterceptor(new DataSecretClassInterceptor());
        WebMvcConfigurer.super.addInterceptors(registry);
    }

//    @Bean
//    @ConditionalOnMissingBean(DataMaskingClassInterceptor.class)
//    public DataMaskingClassInterceptor dataMaskingClassInterceptor(){
//        return new DataMaskingClassInterceptor();
//    }

    @Bean
    @ConditionalOnMissingBean(DataMaskingHandler.class)
    public DataMaskingHandler dataMaskingHandler(){
        return new DataMaskingHandler();
    }

    @Bean
    @ConditionalOnMissingBean(DataSecretHandler.class)
    public DataSecretHandler dataSecretHandler(){
        return new DataSecretHandler();
    }



}
