package cn.com.duiba.cloud.manage.service.api.model.param.sso;

import cn.com.duiba.cloud.manage.service.api.annotation.DataSecretFiledAnnotation;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * 用户注册请求
 *
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RegisterUserParams {

    @Pattern(regexp = "^1[0-9]{10}$", message = "手机号格式不正确")
    private String phone;

    @Pattern(regexp = "^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,16}$", message = "密码格式不正确")
    @DataSecretFiledAnnotation
    private String password;

    @NotNull(message = "短信验证码key不能为空")
    private String smsKey;

    private String name;

}
