package cn.com.duiba.cloud.manage.service.api.model.param.sso;

import cn.com.duiba.cloud.manage.service.api.annotation.DataSecretFiledAnnotation;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Pattern;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class UpdatePasswordParams {

    @Pattern(regexp = "^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,16}$", message = "新密码格式不正确")
    @DataSecretFiledAnnotation
    private String newPassword;
    @Pattern(regexp = "^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,16}$", message = "旧密码格式不正确")
    @DataSecretFiledAnnotation
    private String oldPassword;
    @Pattern(regexp = "^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,16}$", message = "确认密码格式不正确")
    @DataSecretFiledAnnotation
    private String confirmPassword;
}
