package cn.com.duiba.cloud.manage.service.api.model.param.user;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UpdatePasswordParam implements Serializable {

    private static final long serialVersionUID = -9205945061694730824L;

    @NotNull(message = "老密码不能为空")
    private String oldPassword;

    @Pattern(regexp = "^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,16}$", message = "新密码密码格式不正确")
    private String newPassword;

    @NotNull(message = "员工编号不能为空")
    private String userId;
}
