/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.config;

import cn.com.duiba.cloud.manage.service.api.handler.DataMaskingHandler;
import cn.com.duiba.cloud.manage.service.api.handler.DataSecretHandler;
import cn.com.duiba.cloud.manage.service.api.interceptor.DataMaskingClassInterceptor;
import cn.com.duiba.cloud.manage.service.api.interceptor.DataSecretClassInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebAppConfig
implements WebMvcConfigurer {
    public void addInterceptors(InterceptorRegistry registry) {
        DataMaskingClassInterceptor interceptor = new DataMaskingClassInterceptor();
        registry.addInterceptor((HandlerInterceptor)interceptor);
        registry.addInterceptor((HandlerInterceptor)new DataSecretClassInterceptor());
        super.addInterceptors(registry);
    }

    @Bean
    @ConditionalOnMissingBean(value={DataMaskingHandler.class})
    public DataMaskingHandler dataMaskingHandler() {
        return new DataMaskingHandler();
    }

    @Bean
    @ConditionalOnMissingBean(value={DataSecretHandler.class})
    public DataSecretHandler dataSecretHandler() {
        return new DataSecretHandler();
    }
}

