/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.utils;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger(AssertUtil.class);

    public static void isBlank(String str, ErrorCode code, Object ... org) throws BizException {
        AssertUtil.isTrue(StringUtils.isBlank((CharSequence)str), code, org);
    }

    public static void isNotBlank(String str, ErrorCode code, Object ... org) throws BizException {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)str), code, org);
    }

    public static void isEmpty(String str, ErrorCode code, Object ... org) throws BizException {
        AssertUtil.isTrue(StringUtils.isEmpty((CharSequence)str), code, org);
    }

    public static void isNotEmpty(String str, ErrorCode code, Object ... org) throws BizException {
        AssertUtil.isTrue(StringUtils.isNotEmpty((CharSequence)str), code, org);
    }

    public static void isNotNull(Object o, ErrorCode code, Object ... org) throws BizException {
        AssertUtil.isTrue(o != null, code, org);
    }

    public static void isNull(Object o, ErrorCode code, Object ... org) throws BizException {
        AssertUtil.isTrue(o == null, code, org);
    }

    public static void isNotEmpty(Collection c, ErrorCode code, Object ... org) throws BizException {
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)c), code, org);
    }

    public static void isEmpty(Collection c, ErrorCode code, Object ... org) throws BizException {
        AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)c), code, org);
    }

    public static void isMapNotEmpty(Map m, ErrorCode code, Object ... org) throws BizException {
        AssertUtil.isTrue(m != null && !m.isEmpty(), code, org);
    }

    public static void isMapEmpty(Map m, ErrorCode code, Object ... org) throws BizException {
        AssertUtil.isTrue(m == null || m.isEmpty(), code, org);
    }

    public static void isEquals(Object o1, Object o2, ErrorCode code, Object ... org) throws BizException {
        AssertUtil.isTrue(Objects.equals(o1, o2), code, org);
    }

    public static void isNotEquals(Object o1, Object o2, ErrorCode code, Object ... org) throws BizException {
        AssertUtil.isTrue(!Objects.equals(o1, o2), code, org);
    }

    public static void isTrue(boolean as, ErrorCode code, Object ... org) throws BizException {
        if (code == null) {
            code = ErrorCode.ERROR;
        }
        if (!as) {
            String errorMsg = AssertUtil.getErrorMsg(code.getMsg(), org);
            BizException bizException = new BizException(errorMsg).withCode(code.getCode());
            LOGGER.warn("", (Throwable)bizException);
            throw bizException;
        }
    }

    public static String getErrorMsg(String str, Object ... objects) {
        String rlt = str;
        if (objects != null) {
            for (Object object : objects) {
                rlt = rlt.replaceFirst("\\[.*?]", object == null ? "null" : object.toString());
            }
        }
        return rlt;
    }

    public static void main(String[] args) {
        System.out.println(AssertUtil.getErrorMsg("\u4f60\u597d[name1]!,\u6211\u662f[name2]....", "lz", 3));
    }
}

