package cn.com.duiba.cloud.manage.service.api.remoteservice.dept;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.dept.DeptListDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.dept.PositionDeptDto;
import cn.com.duiba.cloud.manage.service.api.model.param.RemoteIdParam;
import cn.com.duiba.cloud.manage.service.api.model.param.dept.RemoteSaveDeptParam;
import cn.com.duiba.cloud.manage.service.api.model.param.dept.RemoteSearchDeptRequest;

import java.util.List;

/**
 * @author linzhou
 * @ClassName ReomteDeptService.java
 * @createTime 2021年11月08日 13:52:00
 * @Description
 */
@AdvancedFeignClient
public interface RemoteDeptService {


    /**
     * 获取子集部门的列表
     *
     * @param param
     * @return
     */
    List<DeptListDTO> getChildDeptList(RemoteIdParam param);

    /**
     * 保存部门
     *
     * @param deptParam
     * @return
     */
    Long saveDept(RemoteSaveDeptParam deptParam) throws BizException;

    void saveDeptList(List<RemoteSaveDeptParam> deptParams) throws BizException;

    /**
     * 删除部门,及其子部门
     *
     * @param deptId
     * @return
     */
    Boolean delDept(Long deptId) throws BizException;


    /**
     * 搜索部门
     *
     * @param param
     * @return
     * @throws BizException
     */
    List<DeptListDTO> searchDept(RemoteSearchDeptRequest param) throws BizException;

    /**
     * 定位部门
     *
     * @param deptId
     * @return
     * @throws BizException
     */
    PositionDeptDto positionDept(Long deptId) throws BizException;
}
