package cn.com.duiba.cloud.manage.service.api.model.enums.app;

import org.apache.commons.lang3.StringUtils;

/**
 * 权限类型
 *
 * @author jiangyesheng
 * @date 2021-11-10
 */
public enum AuthType {
    /** 应用类型 */
    APP("A", "应用"),
    /** 目录类型 */
    DIRECTORY("D", "目录"),
    /** 菜单类型 */
    MENU("M", "菜单"),
    /** 按钮或操作类型 */
    BUTTON("B", "按钮"),
    ;
    private String type;

    private String desc;

    AuthType(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static Boolean isRightType(String type) {
        if (StringUtils.isBlank(type)) {
            return Boolean.FALSE;
        }
        for (AuthType auth : AuthType.values()) {
            if (auth.type.equals(type)) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}
