package cn.com.duiba.cloud.manage.service.api.model.param.supplier;

import cn.com.duiba.cloud.manage.service.api.model.dto.importdata.ImportSaveSupplierGoodsData;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * 保存供应商商品参数
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/21
 */
@Getter
@Setter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RemoteSaveSupplierGoodsParam implements Serializable {

    private static final long serialVersionUID = 4510648928692594800L;

    /**
     * 供应商code
     * @see cn.com.duiba.cloud.manage.service.api.model.constant.supplier.SupplierCodeEnum
     */
    @NotBlank(message = "供应商不能为空")
    private String supplier;

    /**
     * 导入数据
     */
    @NotEmpty(message = "导入数据不能为空")
    private List<ImportSaveSupplierGoodsData> dataList;

}
