package cn.com.duiba.cloud.manage.service.api.model.param.supplier;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 苏宁订单提交
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/18
 */
@Getter
@Setter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RemoteSuningCreateOrderParam implements Serializable {

    private static final long serialVersionUID = -3013538257265084348L;
    /**
     * 必填
     * 交易单号（客户唯一流水号），交易单号多次提交只能生成一个对应的苏宁订单，且多次提交时，订单信息不能发生变化
     */
    @NotBlank(message = "交易单号不能为空")
    private String tradeNo;

    /**
     * 采购企业账号（母公司下单：不传； 子公司下单：传子公司账号）
     */
    private String companyCustNo;

    /**
     * 商品信息
     */
    @NotEmpty(message = "商品信息不能为空")
    private List<RemoteSuningSkuParam> sku;

    /**
     * 必填
     * 收货人（不多于50个汉字）
     */
    @NotBlank(message = "收货人不能为空")
    @Size(max = 50, message = "收货人超过长度限制")
    private String receiverName;

    /**
     * 收货人座机号
     */
    private String telephone;

    /**
     * 必填
     * 收货人手机号
     */
    @NotBlank(message = "收货人手机号不能为空")
    private String mobile;

    /**
     * 收货人邮箱
     */
    private String email;

    /**
     * 必填
     * 省编码
     */
    @NotBlank(message = "省份编码不能为空")
    private String provinceId;

    /**
     * 必填
     * 市编码
     */
    @NotBlank(message = "城市编码不能为空")
    private String cityId;

    /**
     * 必填
     * 区/县编码
     */
    @NotBlank(message = "区/县编码不能为空")
    private String countyId;

    /**
     * 镇编码
     */
    private String townId;

    /**
     * 详细地址（不多于80个汉字）
     */
    @NotBlank(message = "详细地址不能为空")
    @Size(max = 80, message = "详细地址长度过长")
    private String address;

    /**
     * 邮编（6位数字）
     */
    private String zip;

    /**
     * 备注（不多于80个汉字） 如需传给供应商系统，需先联系管理员进行配置（不配置不传）
     */
    private String remark;

    /**
     * 期望送达时间,日期格式:yyyy-MM-dd-X
     * X的取值： 1-白天；2-上午；3-下午；4-晚上 X=1，送货时间为18:00:00； X=2，送货时间为09:00:00； X=3，送货时间为15:00:00；
     * 为保证期望送达时间有效,请先调用suning.govbus.shiptime.get 物流时效接口获取可选送达时间.此为物流配送参考时间,如遇特殊情况可能导致无法按此时间送达.
     */
    private String hopeArrivalTime;

    /**
     * 必填
     * 是否开发票：1=开；0=不开
     */
    @NotBlank(message = "请选择开票")
    private String invoiceState;

    /**
     * 发票类型：1-增值税专票；3-增值税普票（即平推式普票，票货分离）；4-电子发票 ，（invoiceState是否开票=1时必填）
     */
    private String invoiceType;

    /**
     * 发票抬头（invoiceState是否开票=1时必填）
     */
    private String invoiceTitle;

    /**
     * 发票内容：1-明细（invoiceState是否开票=1时必填）
     */
    private String invoiceContent;

    /**
     * 必填 默认08
     * 支付方式：01-在线支付-易付宝；03-货到付款现金；04-货到付款POS；05-支付宝支付；08-账期；09-预付款；11-第三方支付；12-企业汇款支付；020-在线支付-网银；20-账期+在线支付；13-在线支付-快E付
     */
    @NotBlank(message = "请选择支付方式")
    private String payment;

    /**
     * 子支付方式
     */
    private List<RemoteSuningSubPaymentModesParam> subPaymentModes;

    /**
     * 必填
     * 订单总金额=商品单价*数量
     */
    @NotBlank(message = "订单总金额不能为空")
    private String amount;

    /**
     * 必填
     * 订单类型：0-实时型订单； 1-预占型订单（默认：预占型）
     */
    @NotBlank(message = "请选择订单类型")
    private String orderType;

    /**
     * 必填
     * 运费
     */
    @NotBlank(message = "请填写运费")
    private String servFee;

    /**
     * 特殊开票信息
     */
    private RemoteSuningSpecialVatTicketParam specialVatTicket;

    /**
     * 灵活备注（使用前请联系苏宁管理员进行配置）
     */
    private String specRemark;

}
