package cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections.CollectionUtils;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@SuppressWarnings("all")
public class RegionRetailerDTO implements Serializable {

    private static final long serialVersionUID = -5614725328857916568L;
    /**
     * 大区所属省份数据
     */
    List<ProvinceRetailerDTO> provinceRetailerList;

    /**
     * 大区名称
     */
    private String regionName;
    /**
     * 当年目标-户数剔除取关注
     */
    private Long userCountNotFollowingTarget;
    /**
     * 当年目标-新增户数剔除取关注
     */
    private Long userIncreaseCountNotFollowingTarget;
    /**
     * 合计 -户数未剔除取关
     */
    private Long userCount;
    /**
     * 合计 -户数剔除取消关
     */
    private Long userCountNotFollowing;
    /**
     * 当年目标-新增户数剔除取关注
     */
    private Long userIncreaseCountNotFollowing;
    /**
     * 目标进度
     */
    private BigDecimal targetProgress;

    private String targetProgressStr;

    public void setTargetProgress(BigDecimal targetProgress) {
        this.targetProgress = targetProgress;
        if(targetProgress!=null){
            this.targetProgressStr = targetProgress.toPlainString();
        }
    }

    /**
     * 邀请注册量-累计量
     */
    private Long inviteAccumulativeCount;
    /**
     * 邀请注册量-单月量
     */
    private Long inviteSingleMonthCount;
    /**
     * 平和味道自主注册-累计量
     */
    private Long phwdAccumulativeCount;
    /**
     * 平和味道自主注册-单月量
     */
    private Long phwdSingleMonthCount;
    /**
     * 自律小组引流 - 累计量
     */
    private Long selfDisciplineAccumulativeCount;
    /**
     * 自律小组引流 - 单月
     */
    private Long selfDisciplineSingleMonthCount;
    /**
     * 小组联盟引流 -累计量
     */
    private Long leagueAccumulativeCount;
    /**
     * 小组联盟引流 -单月
     */
    private Long leagueSingleMonthCount;
    /**
     * 获客-累计量
     */
    private Long getCustomersAccumulativeCount;
    /**
     * 获客-单月
     */
    private Long getCustomersSingleMonthCount;
    /**
     * 扫码上柜-累计量
     */
    private Long scanCodeAccumulativeCount;
    /**
     * 扫码上柜-单月
     */
    private Long scanCodeSingleMonthCount;
    /**
     * 其他活动-累计量
     */
    private Long othersAccumulativeCount;
    /**
     * 其他活动-单月
     */
    private Long othersSingleMonthCount;

    public void summary() {
        List<ProvinceRetailerDTO> provinceRetailerList = this.provinceRetailerList;
        if (CollectionUtils.isEmpty(provinceRetailerList)) {
            return;
        }
        //累加计算省份数据
        provinceRetailerList.forEach(provinceRetailerDTO -> {
            userCount = add(provinceRetailerDTO.getUserCount(), userCount);
            userCountNotFollowing = add(provinceRetailerDTO.getUserCountNotFollowing(),
                userCountNotFollowing);
            userIncreaseCountNotFollowing = add(
                provinceRetailerDTO.getUserIncreaseCountNotFollowing(),
                userIncreaseCountNotFollowing);
            inviteAccumulativeCount = add(provinceRetailerDTO.getInviteAccumulativeCount(),
                inviteAccumulativeCount);
            inviteSingleMonthCount = add(provinceRetailerDTO.getInviteSingleMonthCount(),
                inviteSingleMonthCount);
            phwdAccumulativeCount = add(provinceRetailerDTO.getPhwdAccumulativeCount(),
                phwdAccumulativeCount);
            phwdSingleMonthCount = add(phwdSingleMonthCount,
                provinceRetailerDTO.getPhwdSingleMonthCount());
            selfDisciplineAccumulativeCount = add(selfDisciplineAccumulativeCount,
                provinceRetailerDTO.getSelfDisciplineAccumulativeCount());
            selfDisciplineSingleMonthCount = add(selfDisciplineSingleMonthCount,
                provinceRetailerDTO.getSelfDisciplineSingleMonthCount());
            leagueAccumulativeCount = add(leagueAccumulativeCount,
                provinceRetailerDTO.getLeagueAccumulativeCount());
            leagueSingleMonthCount = add(leagueSingleMonthCount,
                provinceRetailerDTO.getLeagueSingleMonthCount());
            getCustomersAccumulativeCount = add(getCustomersAccumulativeCount,
                provinceRetailerDTO.getGetCustomersAccumulativeCount());
            getCustomersSingleMonthCount = add(getCustomersSingleMonthCount,
                provinceRetailerDTO.getGetCustomersSingleMonthCount());
            scanCodeAccumulativeCount = add(scanCodeAccumulativeCount,
                provinceRetailerDTO.getScanCodeAccumulativeCount());
            scanCodeSingleMonthCount = add(scanCodeSingleMonthCount,
                provinceRetailerDTO.getScanCodeSingleMonthCount());
            othersAccumulativeCount = add(othersAccumulativeCount,
                provinceRetailerDTO.getOthersAccumulativeCount());
            othersSingleMonthCount = add(othersSingleMonthCount,
                provinceRetailerDTO.getOthersSingleMonthCount());
        });
    }

    public void calculateSchedule() {
        userIncreaseCountNotFollowing= userIncreaseCountNotFollowing==null?0:userIncreaseCountNotFollowing;
        userIncreaseCountNotFollowingTarget = userIncreaseCountNotFollowingTarget==null?0:userIncreaseCountNotFollowingTarget;
        this.setTargetProgress(calculateSchedule(new BigDecimal(userIncreaseCountNotFollowing),
            new BigDecimal(userIncreaseCountNotFollowingTarget)));
        provinceRetailerList.forEach(provinceRetailerDTO -> {
            BigDecimal actualValue = new BigDecimal(
                provinceRetailerDTO.getUserIncreaseCountNotFollowing() == null ? 0
                    : provinceRetailerDTO.getUserIncreaseCountNotFollowing());
            BigDecimal targetValue = new BigDecimal(
                provinceRetailerDTO.getUserIncreaseCountNotFollowingTarget() == null ? 0
                    : provinceRetailerDTO.getUserIncreaseCountNotFollowingTarget());
            provinceRetailerDTO.setTargetProgress( calculateSchedule(actualValue,targetValue));
        });
    }

    private BigDecimal calculateSchedule(BigDecimal actualValue, BigDecimal targetValue) {
        BigDecimal progress = new BigDecimal(0L).setScale(2, BigDecimal.ROUND_HALF_UP);
        // 合计新增户数（剔除取关）÷当年目标新增户数（剔除取关）
        boolean actualFlag = actualValue == null
                                 || actualValue.compareTo(new BigDecimal(0)) == 0;
        boolean targetFlag = targetValue == null
                                 || targetValue.compareTo(new BigDecimal(0)) == 0;
        if (targetFlag || actualFlag) {
            return progress;
        } else {
            // 合计新增户数 * 100 / 当年目标新增户数  四舍五入取两位小数
            progress = actualValue.multiply(new BigDecimal(100))
                           .divide(targetValue,2, BigDecimal.ROUND_HALF_DOWN)
                           .setScale(2, BigDecimal.ROUND_HALF_DOWN);
        }
        return progress;
    }

    private Long add(Long first, Long second) {
        long l = first == null ? 0L : first;
        long l1 = second == null ? 0L : second;
        return l + l1;
    }
}
