package cn.com.duiba.cloud.manage.service.api.model.param.user;

import cn.com.duiba.cloud.manage.service.api.model.constant.RegexpConst;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;


/**
 * @author xuanhongjian
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RegisterUserParam implements Serializable {

    private static final long serialVersionUID = 1814124741562222990L;

    @NotBlank(message = "员工编号不能为空")
    private String userId;

    /**
     * 手机号
     */
    private String phone;

    @Pattern(regexp = RegexpConst.PASSWORD, message = "密码格式不正确")
    private String password;

    @NotNull(message = "名称不能为空")
    private String name;
}
