package cn.com.duiba.cloud.manage.service.api.model.enums.supplier;

/**
 * 得力订单状态
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/2/7
 */
public enum DeliOrderStateEnum {
    /** 1-待审核 2-审核通过 3-已发货 4-已完成 5-已取消 6-已妥投 7-已付款 */
    PENDING_REVIEW(1, "待审核"),
    PASS_REVIEW(2, "审核通过"),
    SHIPPED(3, "已发货"),
    COMPLETED(4, "已完成"),
    CANCEL(5, "已取消"),
    DELIVERED(6, "已妥投"),
    PAID(7, "已付款"),

    ;
    private Integer code;
    private String desc;

    DeliOrderStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
