package cn.com.duiba.cloud.manage.service.api.model.param.terminal;

import cn.com.duiba.cloud.manage.service.api.annotation.EnumValid;
import cn.com.duiba.cloud.manage.service.api.model.enums.AuditOpEnum;
import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/26 16:04
 */
@Getter
@Setter
public class RemotePassAllParam extends BaseParam {

    /**
     * id list
     */
    @NotEmpty(message = "id list 不能为空")
    private List<Long> id;

    /**
     * 活动id
     */
    @NotNull(message = "活动id不能为空")
    private Long activityId;

    /**
     * 操作类型
     * @see AuditOpEnum
     */
    @NotNull(message = "操作类型不能为空")
    @EnumValid(target = AuditOpEnum.class, message = "操作类型不合法")
    private Integer type;
}
