package cn.com.duiba.cloud.manage.service.api.model.param.supplier;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 查询苏宁订单状态
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/18
 */
@Getter
@Setter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RemoteSuningGetOrderStatusParam implements Serializable {

    private static final long serialVersionUID = 555947216958863733L;

    /**
     * 订单号
     */
    @NotBlank(message = "订单号不能为空")
    private String tradeNo;

    /**
     * 第三方订单号 - 如果传入了第三方订单号，会直接使用第三方订单号进行查询
     */
    private String orderId;

}
