package cn.com.duiba.cloud.manage.service.api.remoteservice.terminal;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.terminal.RetailerSelectPageDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.terminal.TerminalReportAuditDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.terminal.TerminalStaffSelectPageDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.terminal.*;
import cn.com.duiba.wolf.entity.PageResponse;

/**
* @author yuanzhixin
* @version 1.0
* @date 2022-05-26 10:38:00
*/
@AdvancedFeignClient
public interface RemoteTerminalReportAuditService {

    /**
     * 选点管理-终端业务员管理分页查询
     * @param param 查询参数
     * @return 分页结果
     * @throws BizException 查询异常
     */
    PageResponse<TerminalStaffSelectPageDTO> terminalPage(RemoteTerminalStaffSelectPageParam param) throws BizException;

    /**
     * 调整指标
     * @param param 修改参数
     * @throws BizException 修改异常
     */
    void adjustQuota(RemoteAdjustQuotaParam param) throws BizException;

    /**
     * 选点管理-零售户管理分页查询
     * @param param 查询参数
     * @return 分页结果
     * @throws BizException 查询异常
     */
    PageResponse<RetailerSelectPageDTO> retailerPage(RemoteRetailerSelectPageParam param) throws BizException;

    /**
     * 全部通过、拒绝
     * @param param 操作参数
     * @throws BizException 操作异常
     */
    void passAll(RemotePassAllParam param) throws BizException;

    /**
     * 批量指派
     * @param param 操作参数
     * @throws BizException 操作异常
     */
    void batchSelect(RemoteBatchSelectParam param) throws BizException;

    /**
     * 根据活动id，终端业务员id查询审核通过的对象
     * @param remoteParam 查询参数
     * @return TerminalReportAuditDTO
     */
    TerminalReportAuditDTO queryPassTerminalRecord(RemoteTerminalPassParam remoteParam);

    /**
     * 保存、更新终端业务员审核状态
     * @param param 保存参数
     */
    void saveOrUpdate(RemoteTerminalReportAuditSaveParam param);

    /**
     * 查询审核情况
     * @param activityId 活动id
     * @param terminalId 终端业务员id
     * @return TerminalReportAuditDTO
     */
    TerminalReportAuditDTO queryByTerminal(Long activityId, Long terminalId);
}
