package cn.com.duiba.cloud.manage.service.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.statistics.PageLogStatisticsDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.statistics.UnitLogStatisticsDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.statistics.RemotePageStatisticsListParam;
import cn.com.duiba.cloud.manage.service.api.model.param.statistics.RemoteStatisticsLogParam;
import cn.com.duiba.cloud.manage.service.api.model.param.statistics.RemoteUnitStatisticsListParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 功能描述：统计数据remote接口
 *
 * @Auther: xiaotian
 * @Date: 2022/2/7 12:03
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteStatisticsService {

    /**
     * 获取页面统计数据
     * @param remotePageStatisticsListParam
     * @return
     */
    PageResponse<PageLogStatisticsDTO> queryPageList(RemotePageStatisticsListParam remotePageStatisticsListParam);

    /**
     * 获取组件统计数据
     * @param remoteUnitStatisticsListParam
     * @return
     */
    PageResponse<UnitLogStatisticsDTO> queryUnitList(RemoteUnitStatisticsListParam remoteUnitStatisticsListParam);

    /**
     * 记录日志
     * @param remoteStatisticsListParam
     */
    void log(RemoteStatisticsLogParam remoteStatisticsListParam);
}
