/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport;

import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.ProvinceConsumerDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class RegionConsumerDTO
implements Serializable {
    private static final long serialVersionUID = 606446136736126832L;
    private String regionName;
    private Long followingCountTarget;
    private Long followingIncreaseCountTarget;
    private Long followingCount;
    private Long registerCount;
    private Long consumerCount;
    private BigDecimal progress;
    private Long increaseCount;
    private BigDecimal secondProgress;
    private List<ProvinceConsumerDTO> provinceConsumerDTOList;

    public void summary() {
        if (CollectionUtils.isEmpty(this.provinceConsumerDTOList)) {
            return;
        }
        this.followingCount = this.followingCount == null ? 0L : this.followingCount;
        this.registerCount = this.registerCount == null ? 0L : this.registerCount;
        this.increaseCount = this.increaseCount == null ? 0L : this.increaseCount;
        this.consumerCount = this.consumerCount == null ? 0L : this.consumerCount;
        for (ProvinceConsumerDTO provinceConsumerDTO : this.provinceConsumerDTOList) {
            this.followingCount = this.add(this.followingCount, provinceConsumerDTO.getFollowingCount());
            this.registerCount = this.add(this.registerCount, provinceConsumerDTO.getRegisterCount());
            this.increaseCount = this.add(this.increaseCount, provinceConsumerDTO.getIncreaseCount());
            this.consumerCount = this.add(this.consumerCount, provinceConsumerDTO.getFollowingCount());
        }
    }

    public void calculateSchedule() {
        if (this.followingCount == null || this.followingCount == 0L) {
            this.progress = new BigDecimal(0).setScale(2, 4);
        } else {
            if (this.followingCountTarget == null || this.followingCountTarget == 0L) {
                this.progress = new BigDecimal(100L).setScale(2, 4);
            }
            this.progress = new BigDecimal(this.followingCount).multiply(new BigDecimal(100)).divide(new BigDecimal(this.followingCountTarget), 2, 5).setScale(2, 4);
        }
        if (this.increaseCount == null || this.increaseCount == 0L) {
            this.secondProgress = new BigDecimal(0).setScale(2, 4);
        } else {
            if (this.followingIncreaseCountTarget == null || this.followingIncreaseCountTarget == 0L) {
                this.secondProgress = new BigDecimal(100L).setScale(2, 4);
            }
            this.secondProgress = new BigDecimal(this.increaseCount).multiply(new BigDecimal(100)).divide(new BigDecimal(this.followingIncreaseCountTarget), 2, 5).setScale(2, 4);
        }
    }

    private Long add(Long first, Long second) {
        long l = first == null ? 0L : first;
        long l1 = second == null ? 0L : second;
        return l + l1;
    }

    public static RegionConsumerDTOBuilder builder() {
        return new RegionConsumerDTOBuilder();
    }

    public String getRegionName() {
        return this.regionName;
    }

    public Long getFollowingCountTarget() {
        return this.followingCountTarget;
    }

    public Long getFollowingIncreaseCountTarget() {
        return this.followingIncreaseCountTarget;
    }

    public Long getFollowingCount() {
        return this.followingCount;
    }

    public Long getRegisterCount() {
        return this.registerCount;
    }

    public Long getConsumerCount() {
        return this.consumerCount;
    }

    public BigDecimal getProgress() {
        return this.progress;
    }

    public Long getIncreaseCount() {
        return this.increaseCount;
    }

    public BigDecimal getSecondProgress() {
        return this.secondProgress;
    }

    public List<ProvinceConsumerDTO> getProvinceConsumerDTOList() {
        return this.provinceConsumerDTOList;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setFollowingCountTarget(Long followingCountTarget) {
        this.followingCountTarget = followingCountTarget;
    }

    public void setFollowingIncreaseCountTarget(Long followingIncreaseCountTarget) {
        this.followingIncreaseCountTarget = followingIncreaseCountTarget;
    }

    public void setFollowingCount(Long followingCount) {
        this.followingCount = followingCount;
    }

    public void setRegisterCount(Long registerCount) {
        this.registerCount = registerCount;
    }

    public void setConsumerCount(Long consumerCount) {
        this.consumerCount = consumerCount;
    }

    public void setProgress(BigDecimal progress) {
        this.progress = progress;
    }

    public void setIncreaseCount(Long increaseCount) {
        this.increaseCount = increaseCount;
    }

    public void setSecondProgress(BigDecimal secondProgress) {
        this.secondProgress = secondProgress;
    }

    public void setProvinceConsumerDTOList(List<ProvinceConsumerDTO> provinceConsumerDTOList) {
        this.provinceConsumerDTOList = provinceConsumerDTOList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegionConsumerDTO)) {
            return false;
        }
        RegionConsumerDTO other = (RegionConsumerDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$regionName = this.getRegionName();
        String other$regionName = other.getRegionName();
        if (this$regionName == null ? other$regionName != null : !this$regionName.equals(other$regionName)) {
            return false;
        }
        Long this$followingCountTarget = this.getFollowingCountTarget();
        Long other$followingCountTarget = other.getFollowingCountTarget();
        if (this$followingCountTarget == null ? other$followingCountTarget != null : !((Object)this$followingCountTarget).equals(other$followingCountTarget)) {
            return false;
        }
        Long this$followingIncreaseCountTarget = this.getFollowingIncreaseCountTarget();
        Long other$followingIncreaseCountTarget = other.getFollowingIncreaseCountTarget();
        if (this$followingIncreaseCountTarget == null ? other$followingIncreaseCountTarget != null : !((Object)this$followingIncreaseCountTarget).equals(other$followingIncreaseCountTarget)) {
            return false;
        }
        Long this$followingCount = this.getFollowingCount();
        Long other$followingCount = other.getFollowingCount();
        if (this$followingCount == null ? other$followingCount != null : !((Object)this$followingCount).equals(other$followingCount)) {
            return false;
        }
        Long this$registerCount = this.getRegisterCount();
        Long other$registerCount = other.getRegisterCount();
        if (this$registerCount == null ? other$registerCount != null : !((Object)this$registerCount).equals(other$registerCount)) {
            return false;
        }
        Long this$consumerCount = this.getConsumerCount();
        Long other$consumerCount = other.getConsumerCount();
        if (this$consumerCount == null ? other$consumerCount != null : !((Object)this$consumerCount).equals(other$consumerCount)) {
            return false;
        }
        BigDecimal this$progress = this.getProgress();
        BigDecimal other$progress = other.getProgress();
        if (this$progress == null ? other$progress != null : !((Object)this$progress).equals(other$progress)) {
            return false;
        }
        Long this$increaseCount = this.getIncreaseCount();
        Long other$increaseCount = other.getIncreaseCount();
        if (this$increaseCount == null ? other$increaseCount != null : !((Object)this$increaseCount).equals(other$increaseCount)) {
            return false;
        }
        BigDecimal this$secondProgress = this.getSecondProgress();
        BigDecimal other$secondProgress = other.getSecondProgress();
        if (this$secondProgress == null ? other$secondProgress != null : !((Object)this$secondProgress).equals(other$secondProgress)) {
            return false;
        }
        List<ProvinceConsumerDTO> this$provinceConsumerDTOList = this.getProvinceConsumerDTOList();
        List<ProvinceConsumerDTO> other$provinceConsumerDTOList = other.getProvinceConsumerDTOList();
        return !(this$provinceConsumerDTOList == null ? other$provinceConsumerDTOList != null : !((Object)this$provinceConsumerDTOList).equals(other$provinceConsumerDTOList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegionConsumerDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $regionName = this.getRegionName();
        result = result * 59 + ($regionName == null ? 43 : $regionName.hashCode());
        Long $followingCountTarget = this.getFollowingCountTarget();
        result = result * 59 + ($followingCountTarget == null ? 43 : ((Object)$followingCountTarget).hashCode());
        Long $followingIncreaseCountTarget = this.getFollowingIncreaseCountTarget();
        result = result * 59 + ($followingIncreaseCountTarget == null ? 43 : ((Object)$followingIncreaseCountTarget).hashCode());
        Long $followingCount = this.getFollowingCount();
        result = result * 59 + ($followingCount == null ? 43 : ((Object)$followingCount).hashCode());
        Long $registerCount = this.getRegisterCount();
        result = result * 59 + ($registerCount == null ? 43 : ((Object)$registerCount).hashCode());
        Long $consumerCount = this.getConsumerCount();
        result = result * 59 + ($consumerCount == null ? 43 : ((Object)$consumerCount).hashCode());
        BigDecimal $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : ((Object)$progress).hashCode());
        Long $increaseCount = this.getIncreaseCount();
        result = result * 59 + ($increaseCount == null ? 43 : ((Object)$increaseCount).hashCode());
        BigDecimal $secondProgress = this.getSecondProgress();
        result = result * 59 + ($secondProgress == null ? 43 : ((Object)$secondProgress).hashCode());
        List<ProvinceConsumerDTO> $provinceConsumerDTOList = this.getProvinceConsumerDTOList();
        result = result * 59 + ($provinceConsumerDTOList == null ? 43 : ((Object)$provinceConsumerDTOList).hashCode());
        return result;
    }

    public String toString() {
        return "RegionConsumerDTO(regionName=" + this.getRegionName() + ", followingCountTarget=" + this.getFollowingCountTarget() + ", followingIncreaseCountTarget=" + this.getFollowingIncreaseCountTarget() + ", followingCount=" + this.getFollowingCount() + ", registerCount=" + this.getRegisterCount() + ", consumerCount=" + this.getConsumerCount() + ", progress=" + this.getProgress() + ", increaseCount=" + this.getIncreaseCount() + ", secondProgress=" + this.getSecondProgress() + ", provinceConsumerDTOList=" + this.getProvinceConsumerDTOList() + ")";
    }

    public RegionConsumerDTO(String regionName, Long followingCountTarget, Long followingIncreaseCountTarget, Long followingCount, Long registerCount, Long consumerCount, BigDecimal progress, Long increaseCount, BigDecimal secondProgress, List<ProvinceConsumerDTO> provinceConsumerDTOList) {
        this.regionName = regionName;
        this.followingCountTarget = followingCountTarget;
        this.followingIncreaseCountTarget = followingIncreaseCountTarget;
        this.followingCount = followingCount;
        this.registerCount = registerCount;
        this.consumerCount = consumerCount;
        this.progress = progress;
        this.increaseCount = increaseCount;
        this.secondProgress = secondProgress;
        this.provinceConsumerDTOList = provinceConsumerDTOList;
    }

    public RegionConsumerDTO() {
    }

    public static class RegionConsumerDTOBuilder {
        private String regionName;
        private Long followingCountTarget;
        private Long followingIncreaseCountTarget;
        private Long followingCount;
        private Long registerCount;
        private Long consumerCount;
        private BigDecimal progress;
        private Long increaseCount;
        private BigDecimal secondProgress;
        private List<ProvinceConsumerDTO> provinceConsumerDTOList;

        RegionConsumerDTOBuilder() {
        }

        public RegionConsumerDTOBuilder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public RegionConsumerDTOBuilder followingCountTarget(Long followingCountTarget) {
            this.followingCountTarget = followingCountTarget;
            return this;
        }

        public RegionConsumerDTOBuilder followingIncreaseCountTarget(Long followingIncreaseCountTarget) {
            this.followingIncreaseCountTarget = followingIncreaseCountTarget;
            return this;
        }

        public RegionConsumerDTOBuilder followingCount(Long followingCount) {
            this.followingCount = followingCount;
            return this;
        }

        public RegionConsumerDTOBuilder registerCount(Long registerCount) {
            this.registerCount = registerCount;
            return this;
        }

        public RegionConsumerDTOBuilder consumerCount(Long consumerCount) {
            this.consumerCount = consumerCount;
            return this;
        }

        public RegionConsumerDTOBuilder progress(BigDecimal progress) {
            this.progress = progress;
            return this;
        }

        public RegionConsumerDTOBuilder increaseCount(Long increaseCount) {
            this.increaseCount = increaseCount;
            return this;
        }

        public RegionConsumerDTOBuilder secondProgress(BigDecimal secondProgress) {
            this.secondProgress = secondProgress;
            return this;
        }

        public RegionConsumerDTOBuilder provinceConsumerDTOList(List<ProvinceConsumerDTO> provinceConsumerDTOList) {
            this.provinceConsumerDTOList = provinceConsumerDTOList;
            return this;
        }

        public RegionConsumerDTO build() {
            return new RegionConsumerDTO(this.regionName, this.followingCountTarget, this.followingIncreaseCountTarget, this.followingCount, this.registerCount, this.consumerCount, this.progress, this.increaseCount, this.secondProgress, this.provinceConsumerDTOList);
        }

        public String toString() {
            return "RegionConsumerDTO.RegionConsumerDTOBuilder(regionName=" + this.regionName + ", followingCountTarget=" + this.followingCountTarget + ", followingIncreaseCountTarget=" + this.followingIncreaseCountTarget + ", followingCount=" + this.followingCount + ", registerCount=" + this.registerCount + ", consumerCount=" + this.consumerCount + ", progress=" + this.progress + ", increaseCount=" + this.increaseCount + ", secondProgress=" + this.secondProgress + ", provinceConsumerDTOList=" + this.provinceConsumerDTOList + ")";
        }
    }
}

