/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.model.enums.report;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public enum RegionDivideEnum {
    NORTH_CHINA("\u534e\u5317", Lists.newArrayList((Object[])new String[]{"\u5317\u4eac", "\u5929\u6d25\u5e02", "\u6cb3\u5317"})),
    NORTHEAST("\u4e1c\u5317", Lists.newArrayList((Object[])new String[]{"\u8fbd\u5b81", "\u5409\u6797", "\u9ed1\u9f99\u6c5f"})),
    EAST_CHINA("\u534e\u4e1c", Lists.newArrayList((Object[])new String[]{"\u4e0a\u6d77", "\u6c5f\u82cf", "\u5b89\u5fbd", "\u5c71\u4e1c"})),
    SOUTH_CHINA("\u534e\u5357", Lists.newArrayList((Object[])new String[]{"\u5e7f\u4e1c", "\u5e7f\u897f", "\u6d77\u5357"})),
    CENTRAL_SOUTH("\u4e2d\u5357", Lists.newArrayList((Object[])new String[]{"\u798f\u5efa", "\u6e56\u5357", "\u6c5f\u897f", "\u6e56\u5317"})),
    NORTHWEST("\u897f\u5317", Lists.newArrayList((Object[])new String[]{"\u5185\u8499", "\u7518\u8083", "\u65b0\u7586", "\u9752\u6d77", "\u5b81\u590f"})),
    SOUTHWEST("\u897f\u5357", Lists.newArrayList((Object[])new String[]{"\u4e91\u5357", "\u8d35\u5dde", "\u56db\u5ddd", "\u91cd\u5e86"})),
    CENTRAL_PLAIN("\u4e2d\u539f", Lists.newArrayList((Object[])new String[]{"\u9655\u897f", "\u6cb3\u5357", "\u5c71\u897f"}));

    private static final ImmutableMap<String, RegionDivideEnum> INNER_MAP;
    private final String regionName;
    private final List<String> provinceName;

    private RegionDivideEnum(String regionName, List<String> provinceName) {
        this.regionName = regionName;
        this.provinceName = provinceName;
    }

    public static RegionDivideEnum getByCode(String regionName) {
        return Objects.isNull(regionName) ? null : (RegionDivideEnum)((Object)INNER_MAP.get((Object)regionName));
    }

    public static RegionDivideEnum getByProvinceName(String provinceName) {
        for (Map.Entry entry : INNER_MAP.entrySet()) {
            String k = (String)entry.getKey();
            RegionDivideEnum v = (RegionDivideEnum)((Object)entry.getValue());
            List<String> provinceNames = v.getProvinceName();
            boolean b = provinceNames.stream().anyMatch(provinceName::contains);
            if (!b) continue;
            return v;
        }
        return null;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public List<String> getProvinceName() {
        return this.provinceName;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (RegionDivideEnum item : RegionDivideEnum.values()) {
            builder = builder.put((Object)item.getRegionName(), (Object)item);
        }
        INNER_MAP = builder.build();
    }
}

