/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport;

import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.CityConsumerDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class ProvinceConsumerDTO
implements Serializable {
    private static final long serialVersionUID = 606446136736126832L;
    List<CityConsumerDTO> cityConsumerDTOList;
    private String provinceName;
    private String code;
    private Long followingCountTarget;
    private Long followingIncreaseCountTarget;
    private Long followingCount;
    private Long registerCount;
    private Long consumerCount;
    private BigDecimal progress;
    private String progressStr;
    private String secondProgressStr;
    private Long increaseCount;
    private BigDecimal secondProgress;

    public void setProgress(BigDecimal progress) {
        this.progress = progress;
        if (progress != null) {
            this.progressStr = progress.toPlainString();
        }
    }

    public void setSecondProgress(BigDecimal secondProgress) {
        this.secondProgress = secondProgress;
        if (secondProgress != null) {
            this.secondProgressStr = secondProgress.toPlainString();
        }
    }

    public void summary() {
        if (CollectionUtils.isEmpty(this.cityConsumerDTOList)) {
            return;
        }
        this.followingCount = this.followingCount == null ? 0L : this.followingCount;
        this.registerCount = this.registerCount == null ? 0L : this.registerCount;
        this.increaseCount = this.increaseCount == null ? 0L : this.increaseCount;
        this.consumerCount = this.consumerCount == null ? 0L : this.consumerCount;
        for (CityConsumerDTO cityConsumerDTO : this.cityConsumerDTOList) {
            long cityFollowCount = cityConsumerDTO.getFollowingCount() == null ? 0L : cityConsumerDTO.getFollowingCount();
            this.followingCount = cityFollowCount + this.followingCount;
            long cityRegisterCount = cityConsumerDTO.getRegisterCount() == null ? 0L : cityConsumerDTO.getRegisterCount();
            this.registerCount = cityRegisterCount + this.registerCount;
            long cityIncr = cityConsumerDTO.getIncreaseCount() == null ? 0L : cityConsumerDTO.getIncreaseCount();
            this.increaseCount = cityIncr + this.increaseCount;
            Long cityConsumerCount = cityConsumerDTO.getConsumerCount() == null ? 0L : cityConsumerDTO.getConsumerCount();
            this.consumerCount = this.consumerCount + cityConsumerCount;
        }
    }

    public void calculateSchedule() {
        this.setProgress(this.firstSchedule(this.followingCount, this.followingCountTarget));
        this.setSecondProgress(this.secondSchedule(this.increaseCount, this.followingIncreaseCountTarget));
        if (CollectionUtils.isNotEmpty(this.cityConsumerDTOList)) {
            this.cityConsumerDTOList.forEach(cityConsumerDTO -> {
                cityConsumerDTO.setProgress(this.firstSchedule(cityConsumerDTO.getFollowingCount(), cityConsumerDTO.getFollowingCountTarget()));
                cityConsumerDTO.setSecondProgress(this.secondSchedule(cityConsumerDTO.getIncreaseCount(), cityConsumerDTO.getFollowingIncreaseCountTarget()));
            });
        }
    }

    private BigDecimal firstSchedule(Long followingCount, Long followingCountTarget) {
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2, 4);
        bigDecimal = followingCount == null || followingCount == 0L ? new BigDecimal(0L).setScale(2, 4) : (followingCountTarget == null || followingCountTarget == 0L ? new BigDecimal(0L).setScale(2, 4) : new BigDecimal(followingCount).multiply(new BigDecimal(100)).divide(new BigDecimal(followingCountTarget), 2, 5).setScale(2, 4));
        return bigDecimal;
    }

    private BigDecimal secondSchedule(Long increaseCount, Long followingIncreaseCountTarget) {
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2, 4);
        bigDecimal = increaseCount == null || increaseCount == 0L ? new BigDecimal(0).setScale(2, 4) : (followingIncreaseCountTarget == null || followingIncreaseCountTarget == 0L ? new BigDecimal(0L).setScale(2, 4) : new BigDecimal(increaseCount).multiply(new BigDecimal(100)).divide(new BigDecimal(followingIncreaseCountTarget), 2, 5).setScale(2, 4));
        return bigDecimal;
    }

    public static ProvinceConsumerDTOBuilder builder() {
        return new ProvinceConsumerDTOBuilder();
    }

    public List<CityConsumerDTO> getCityConsumerDTOList() {
        return this.cityConsumerDTOList;
    }

    public String getProvinceName() {
        return this.provinceName;
    }

    public String getCode() {
        return this.code;
    }

    public Long getFollowingCountTarget() {
        return this.followingCountTarget;
    }

    public Long getFollowingIncreaseCountTarget() {
        return this.followingIncreaseCountTarget;
    }

    public Long getFollowingCount() {
        return this.followingCount;
    }

    public Long getRegisterCount() {
        return this.registerCount;
    }

    public Long getConsumerCount() {
        return this.consumerCount;
    }

    public BigDecimal getProgress() {
        return this.progress;
    }

    public String getProgressStr() {
        return this.progressStr;
    }

    public String getSecondProgressStr() {
        return this.secondProgressStr;
    }

    public Long getIncreaseCount() {
        return this.increaseCount;
    }

    public BigDecimal getSecondProgress() {
        return this.secondProgress;
    }

    public void setCityConsumerDTOList(List<CityConsumerDTO> cityConsumerDTOList) {
        this.cityConsumerDTOList = cityConsumerDTOList;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setFollowingCountTarget(Long followingCountTarget) {
        this.followingCountTarget = followingCountTarget;
    }

    public void setFollowingIncreaseCountTarget(Long followingIncreaseCountTarget) {
        this.followingIncreaseCountTarget = followingIncreaseCountTarget;
    }

    public void setFollowingCount(Long followingCount) {
        this.followingCount = followingCount;
    }

    public void setRegisterCount(Long registerCount) {
        this.registerCount = registerCount;
    }

    public void setConsumerCount(Long consumerCount) {
        this.consumerCount = consumerCount;
    }

    public void setProgressStr(String progressStr) {
        this.progressStr = progressStr;
    }

    public void setSecondProgressStr(String secondProgressStr) {
        this.secondProgressStr = secondProgressStr;
    }

    public void setIncreaseCount(Long increaseCount) {
        this.increaseCount = increaseCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProvinceConsumerDTO)) {
            return false;
        }
        ProvinceConsumerDTO other = (ProvinceConsumerDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<CityConsumerDTO> this$cityConsumerDTOList = this.getCityConsumerDTOList();
        List<CityConsumerDTO> other$cityConsumerDTOList = other.getCityConsumerDTOList();
        if (this$cityConsumerDTOList == null ? other$cityConsumerDTOList != null : !((Object)this$cityConsumerDTOList).equals(other$cityConsumerDTOList)) {
            return false;
        }
        String this$provinceName = this.getProvinceName();
        String other$provinceName = other.getProvinceName();
        if (this$provinceName == null ? other$provinceName != null : !this$provinceName.equals(other$provinceName)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        Long this$followingCountTarget = this.getFollowingCountTarget();
        Long other$followingCountTarget = other.getFollowingCountTarget();
        if (this$followingCountTarget == null ? other$followingCountTarget != null : !((Object)this$followingCountTarget).equals(other$followingCountTarget)) {
            return false;
        }
        Long this$followingIncreaseCountTarget = this.getFollowingIncreaseCountTarget();
        Long other$followingIncreaseCountTarget = other.getFollowingIncreaseCountTarget();
        if (this$followingIncreaseCountTarget == null ? other$followingIncreaseCountTarget != null : !((Object)this$followingIncreaseCountTarget).equals(other$followingIncreaseCountTarget)) {
            return false;
        }
        Long this$followingCount = this.getFollowingCount();
        Long other$followingCount = other.getFollowingCount();
        if (this$followingCount == null ? other$followingCount != null : !((Object)this$followingCount).equals(other$followingCount)) {
            return false;
        }
        Long this$registerCount = this.getRegisterCount();
        Long other$registerCount = other.getRegisterCount();
        if (this$registerCount == null ? other$registerCount != null : !((Object)this$registerCount).equals(other$registerCount)) {
            return false;
        }
        Long this$consumerCount = this.getConsumerCount();
        Long other$consumerCount = other.getConsumerCount();
        if (this$consumerCount == null ? other$consumerCount != null : !((Object)this$consumerCount).equals(other$consumerCount)) {
            return false;
        }
        BigDecimal this$progress = this.getProgress();
        BigDecimal other$progress = other.getProgress();
        if (this$progress == null ? other$progress != null : !((Object)this$progress).equals(other$progress)) {
            return false;
        }
        String this$progressStr = this.getProgressStr();
        String other$progressStr = other.getProgressStr();
        if (this$progressStr == null ? other$progressStr != null : !this$progressStr.equals(other$progressStr)) {
            return false;
        }
        String this$secondProgressStr = this.getSecondProgressStr();
        String other$secondProgressStr = other.getSecondProgressStr();
        if (this$secondProgressStr == null ? other$secondProgressStr != null : !this$secondProgressStr.equals(other$secondProgressStr)) {
            return false;
        }
        Long this$increaseCount = this.getIncreaseCount();
        Long other$increaseCount = other.getIncreaseCount();
        if (this$increaseCount == null ? other$increaseCount != null : !((Object)this$increaseCount).equals(other$increaseCount)) {
            return false;
        }
        BigDecimal this$secondProgress = this.getSecondProgress();
        BigDecimal other$secondProgress = other.getSecondProgress();
        return !(this$secondProgress == null ? other$secondProgress != null : !((Object)this$secondProgress).equals(other$secondProgress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProvinceConsumerDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<CityConsumerDTO> $cityConsumerDTOList = this.getCityConsumerDTOList();
        result = result * 59 + ($cityConsumerDTOList == null ? 43 : ((Object)$cityConsumerDTOList).hashCode());
        String $provinceName = this.getProvinceName();
        result = result * 59 + ($provinceName == null ? 43 : $provinceName.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        Long $followingCountTarget = this.getFollowingCountTarget();
        result = result * 59 + ($followingCountTarget == null ? 43 : ((Object)$followingCountTarget).hashCode());
        Long $followingIncreaseCountTarget = this.getFollowingIncreaseCountTarget();
        result = result * 59 + ($followingIncreaseCountTarget == null ? 43 : ((Object)$followingIncreaseCountTarget).hashCode());
        Long $followingCount = this.getFollowingCount();
        result = result * 59 + ($followingCount == null ? 43 : ((Object)$followingCount).hashCode());
        Long $registerCount = this.getRegisterCount();
        result = result * 59 + ($registerCount == null ? 43 : ((Object)$registerCount).hashCode());
        Long $consumerCount = this.getConsumerCount();
        result = result * 59 + ($consumerCount == null ? 43 : ((Object)$consumerCount).hashCode());
        BigDecimal $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : ((Object)$progress).hashCode());
        String $progressStr = this.getProgressStr();
        result = result * 59 + ($progressStr == null ? 43 : $progressStr.hashCode());
        String $secondProgressStr = this.getSecondProgressStr();
        result = result * 59 + ($secondProgressStr == null ? 43 : $secondProgressStr.hashCode());
        Long $increaseCount = this.getIncreaseCount();
        result = result * 59 + ($increaseCount == null ? 43 : ((Object)$increaseCount).hashCode());
        BigDecimal $secondProgress = this.getSecondProgress();
        result = result * 59 + ($secondProgress == null ? 43 : ((Object)$secondProgress).hashCode());
        return result;
    }

    public String toString() {
        return "ProvinceConsumerDTO(cityConsumerDTOList=" + this.getCityConsumerDTOList() + ", provinceName=" + this.getProvinceName() + ", code=" + this.getCode() + ", followingCountTarget=" + this.getFollowingCountTarget() + ", followingIncreaseCountTarget=" + this.getFollowingIncreaseCountTarget() + ", followingCount=" + this.getFollowingCount() + ", registerCount=" + this.getRegisterCount() + ", consumerCount=" + this.getConsumerCount() + ", progress=" + this.getProgress() + ", progressStr=" + this.getProgressStr() + ", secondProgressStr=" + this.getSecondProgressStr() + ", increaseCount=" + this.getIncreaseCount() + ", secondProgress=" + this.getSecondProgress() + ")";
    }

    public ProvinceConsumerDTO(List<CityConsumerDTO> cityConsumerDTOList, String provinceName, String code, Long followingCountTarget, Long followingIncreaseCountTarget, Long followingCount, Long registerCount, Long consumerCount, BigDecimal progress, String progressStr, String secondProgressStr, Long increaseCount, BigDecimal secondProgress) {
        this.cityConsumerDTOList = cityConsumerDTOList;
        this.provinceName = provinceName;
        this.code = code;
        this.followingCountTarget = followingCountTarget;
        this.followingIncreaseCountTarget = followingIncreaseCountTarget;
        this.followingCount = followingCount;
        this.registerCount = registerCount;
        this.consumerCount = consumerCount;
        this.progress = progress;
        this.progressStr = progressStr;
        this.secondProgressStr = secondProgressStr;
        this.increaseCount = increaseCount;
        this.secondProgress = secondProgress;
    }

    public ProvinceConsumerDTO() {
    }

    public static class ProvinceConsumerDTOBuilder {
        private List<CityConsumerDTO> cityConsumerDTOList;
        private String provinceName;
        private String code;
        private Long followingCountTarget;
        private Long followingIncreaseCountTarget;
        private Long followingCount;
        private Long registerCount;
        private Long consumerCount;
        private BigDecimal progress;
        private String progressStr;
        private String secondProgressStr;
        private Long increaseCount;
        private BigDecimal secondProgress;

        ProvinceConsumerDTOBuilder() {
        }

        public ProvinceConsumerDTOBuilder cityConsumerDTOList(List<CityConsumerDTO> cityConsumerDTOList) {
            this.cityConsumerDTOList = cityConsumerDTOList;
            return this;
        }

        public ProvinceConsumerDTOBuilder provinceName(String provinceName) {
            this.provinceName = provinceName;
            return this;
        }

        public ProvinceConsumerDTOBuilder code(String code) {
            this.code = code;
            return this;
        }

        public ProvinceConsumerDTOBuilder followingCountTarget(Long followingCountTarget) {
            this.followingCountTarget = followingCountTarget;
            return this;
        }

        public ProvinceConsumerDTOBuilder followingIncreaseCountTarget(Long followingIncreaseCountTarget) {
            this.followingIncreaseCountTarget = followingIncreaseCountTarget;
            return this;
        }

        public ProvinceConsumerDTOBuilder followingCount(Long followingCount) {
            this.followingCount = followingCount;
            return this;
        }

        public ProvinceConsumerDTOBuilder registerCount(Long registerCount) {
            this.registerCount = registerCount;
            return this;
        }

        public ProvinceConsumerDTOBuilder consumerCount(Long consumerCount) {
            this.consumerCount = consumerCount;
            return this;
        }

        public ProvinceConsumerDTOBuilder progress(BigDecimal progress) {
            this.progress = progress;
            return this;
        }

        public ProvinceConsumerDTOBuilder progressStr(String progressStr) {
            this.progressStr = progressStr;
            return this;
        }

        public ProvinceConsumerDTOBuilder secondProgressStr(String secondProgressStr) {
            this.secondProgressStr = secondProgressStr;
            return this;
        }

        public ProvinceConsumerDTOBuilder increaseCount(Long increaseCount) {
            this.increaseCount = increaseCount;
            return this;
        }

        public ProvinceConsumerDTOBuilder secondProgress(BigDecimal secondProgress) {
            this.secondProgress = secondProgress;
            return this;
        }

        public ProvinceConsumerDTO build() {
            return new ProvinceConsumerDTO(this.cityConsumerDTOList, this.provinceName, this.code, this.followingCountTarget, this.followingIncreaseCountTarget, this.followingCount, this.registerCount, this.consumerCount, this.progress, this.progressStr, this.secondProgressStr, this.increaseCount, this.secondProgress);
        }

        public String toString() {
            return "ProvinceConsumerDTO.ProvinceConsumerDTOBuilder(cityConsumerDTOList=" + this.cityConsumerDTOList + ", provinceName=" + this.provinceName + ", code=" + this.code + ", followingCountTarget=" + this.followingCountTarget + ", followingIncreaseCountTarget=" + this.followingIncreaseCountTarget + ", followingCount=" + this.followingCount + ", registerCount=" + this.registerCount + ", consumerCount=" + this.consumerCount + ", progress=" + this.progress + ", progressStr=" + this.progressStr + ", secondProgressStr=" + this.secondProgressStr + ", increaseCount=" + this.increaseCount + ", secondProgress=" + this.secondProgress + ")";
        }
    }
}

