package cn.com.duiba.cloud.manage.service.api.model.dto.report;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 零售户入网
 * @author xuanhongjian
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@SuppressWarnings("all")
public class RetailerDTO implements Serializable {
    private static final long serialVersionUID = 1102718850533441228L;
    /**
     * 日期
     */
    private Date curDate;
    /**
     * '统计类型1:平台数据 2:平台数据-剔除版'
     */
    private Integer statisType;
    /**
     * '0:合计 1:省内 2:省外'
     */
    private Integer regionType;
    /**
     * '合计-累计量'
     */
    private Long accumulateUv;
    /**
     * '当年-累计量'
     */
    private Long currentYearAccumulateUv;
    /**
     * '批量导入邀请注册 （终端基础入网）-累计量'
     */
    private Long pldrAccumulateUv;
    /**
     * '当年-批量导入邀请注册 （终端基础入网）-累计量'
     */
    private Long pldrCurrentYearAccumulateUv;

    /**
     * '平和味道自主注册 （终端基础入网）-累计量'
     */
    private Long phwdAccumulateUv;
    /**
     * '当年-平和味道自主注册 （终端基础入网）-累计量'
     */
    private Long phwdCurrentYearAccumulateUv;
    /**
     * '核心零售户地推引流 （终端基础入网）-累计量'
     */
    private Long dtylAccumulateUv;

    /**
     * '当年-核心零售户地推引流 （终端基础入网）-累计量'
     */
    private Long dtylCurrentYearAccumulateUv;

    /**
     * '拉新邀请入网 （活动引流入网）-累计量'
     */
    private Long lxrwAccumulateUv;

    /**
     * '当年-拉新邀请入网 （活动引流入网）-累计量'
     */
    private Long lxrwCurrentYearAccumulateUv;

    /**
     * '获客 (活动引流入网）-累计量'
     */
    private Long hkAccumulateUv;

    /**
     * '当年-获客 (活动引流入网）-累计量'
     */
    private Long hkCurrentYearAccumulateUv;

    /**
     * '扫码上柜（活动引流入网）-累计量'
     */
    private Long smsgAccumulateUv;

    /**
     * '当年-扫码上柜（活动引流入网）-累计量'
     */
    private Long smsgCurrentYearAccumulateUv;
    /**
     * '软蓝陈列  （活动引流入网）-累计量'
     */
    private Long rlclAccumulateUv;

    /**
     * '当年-软蓝陈列  （活动引流入网）-累计量'
     */
    private Long rlclCurrentYearAccumulateUv;

    /**
     * '付费陈列（付费终端入网））-累计量'
     */
    private Long ffclAccumulateUv;

    /**
     * '当年-付费陈列（付费终端入网）-累计量'
     */
    private Long ffclCurrentYearAccumulateUv;
}
