package cn.com.duiba.cloud.manage.service.api.model.enums.supplier;

import java.util.Objects;

/**
 * 供应商类型
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/17
 */
public enum SupplierCodeEnum {

    /**
     *
     */
    DELI("deli", "得力"),
    SUNING("suning", "苏宁"),
    ;
    private String code;
    private String desc;

    SupplierCodeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static SupplierCodeEnum getEnum(String code){
        for (SupplierCodeEnum value : SupplierCodeEnum.values()) {
            if (Objects.equals(value.code,code)){
                return value;
            }
        }
        return null;
    }
}
