/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport;

import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.BusinessConsumerDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport.CityConsumerDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class ProvinceConsumerDTO
extends BusinessConsumerDTO
implements Serializable {
    private static final long serialVersionUID = 606446136736126832L;
    List<CityConsumerDTO> cityConsumerDTOList;
    private String provinceName;
    private String code;

    @Override
    public void setProgress(BigDecimal progress) {
        this.progress = progress;
        if (progress != null) {
            this.progressStr = progress.toPlainString();
        }
    }

    @Override
    public void setSecondProgress(BigDecimal secondProgress) {
        this.secondProgress = secondProgress;
        if (secondProgress != null) {
            this.secondProgressStr = secondProgress.toPlainString();
        }
    }

    public void summary() {
        if (CollectionUtils.isEmpty(this.cityConsumerDTOList)) {
            return;
        }
        this.followingCount = this.followingCount == null ? 0L : this.followingCount;
        this.registerCount = this.registerCount == null ? 0L : this.registerCount;
        this.increaseCount = this.increaseCount == null ? 0L : this.increaseCount;
        this.consumerCount = this.consumerCount == null ? 0L : this.consumerCount;
        for (CityConsumerDTO cityConsumerDTO : this.cityConsumerDTOList) {
            long cityFollowCount = cityConsumerDTO.getFollowingCount() == null ? 0L : cityConsumerDTO.getFollowingCount();
            this.followingCount = cityFollowCount + this.followingCount;
            long cityRegisterCount = cityConsumerDTO.getRegisterCount() == null ? 0L : cityConsumerDTO.getRegisterCount();
            this.registerCount = cityRegisterCount + this.registerCount;
            long cityIncr = cityConsumerDTO.getIncreaseCount() == null ? 0L : cityConsumerDTO.getIncreaseCount();
            this.increaseCount = cityIncr + this.increaseCount;
            Long cityConsumerCount = cityConsumerDTO.getConsumerCount() == null ? 0L : cityConsumerDTO.getConsumerCount();
            this.consumerCount = this.consumerCount + cityConsumerCount;
        }
    }

    public void calculateSchedule() {
        this.setProgress(this.firstSchedule(this.followingCount, this.followingCountTarget));
        this.setSecondProgress(this.secondSchedule(this.increaseCount, this.followingIncreaseCountTarget));
        if (CollectionUtils.isNotEmpty(this.cityConsumerDTOList)) {
            this.cityConsumerDTOList.forEach(cityConsumerDTO -> {
                cityConsumerDTO.setProgress(this.firstSchedule(cityConsumerDTO.getFollowingCount(), cityConsumerDTO.getFollowingCountTarget()));
                cityConsumerDTO.setSecondProgress(this.secondSchedule(cityConsumerDTO.getIncreaseCount(), cityConsumerDTO.getFollowingIncreaseCountTarget()));
            });
        }
    }

    private BigDecimal firstSchedule(Long followingCount, Long followingCountTarget) {
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2, 4);
        bigDecimal = followingCount == null || followingCount == 0L ? new BigDecimal(0L).setScale(2, 4) : (followingCountTarget == null || followingCountTarget == 0L ? new BigDecimal(0L).setScale(2, 4) : new BigDecimal(followingCount).multiply(new BigDecimal(100)).divide(new BigDecimal(followingCountTarget), 2, 5).setScale(2, 4));
        return bigDecimal;
    }

    private BigDecimal secondSchedule(Long increaseCount, Long followingIncreaseCountTarget) {
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2, 4);
        bigDecimal = increaseCount == null || increaseCount == 0L ? new BigDecimal(0).setScale(2, 4) : (followingIncreaseCountTarget == null || followingIncreaseCountTarget == 0L ? new BigDecimal(0L).setScale(2, 4) : new BigDecimal(increaseCount).multiply(new BigDecimal(100)).divide(new BigDecimal(followingIncreaseCountTarget), 2, 5).setScale(2, 4));
        return bigDecimal;
    }

    public static ProvinceConsumerDTOBuilder builder() {
        return new ProvinceConsumerDTOBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProvinceConsumerDTO)) {
            return false;
        }
        ProvinceConsumerDTO other = (ProvinceConsumerDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<CityConsumerDTO> this$cityConsumerDTOList = this.getCityConsumerDTOList();
        List<CityConsumerDTO> other$cityConsumerDTOList = other.getCityConsumerDTOList();
        if (this$cityConsumerDTOList == null ? other$cityConsumerDTOList != null : !((Object)this$cityConsumerDTOList).equals(other$cityConsumerDTOList)) {
            return false;
        }
        String this$provinceName = this.getProvinceName();
        String other$provinceName = other.getProvinceName();
        if (this$provinceName == null ? other$provinceName != null : !this$provinceName.equals(other$provinceName)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        return !(this$code == null ? other$code != null : !this$code.equals(other$code));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProvinceConsumerDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<CityConsumerDTO> $cityConsumerDTOList = this.getCityConsumerDTOList();
        result = result * 59 + ($cityConsumerDTOList == null ? 43 : ((Object)$cityConsumerDTOList).hashCode());
        String $provinceName = this.getProvinceName();
        result = result * 59 + ($provinceName == null ? 43 : $provinceName.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        return result;
    }

    public List<CityConsumerDTO> getCityConsumerDTOList() {
        return this.cityConsumerDTOList;
    }

    public String getProvinceName() {
        return this.provinceName;
    }

    public String getCode() {
        return this.code;
    }

    public void setCityConsumerDTOList(List<CityConsumerDTO> cityConsumerDTOList) {
        this.cityConsumerDTOList = cityConsumerDTOList;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String toString() {
        return "ProvinceConsumerDTO(cityConsumerDTOList=" + this.getCityConsumerDTOList() + ", provinceName=" + this.getProvinceName() + ", code=" + this.getCode() + ")";
    }

    public ProvinceConsumerDTO(List<CityConsumerDTO> cityConsumerDTOList, String provinceName, String code) {
        this.cityConsumerDTOList = cityConsumerDTOList;
        this.provinceName = provinceName;
        this.code = code;
    }

    public ProvinceConsumerDTO() {
    }

    public static class ProvinceConsumerDTOBuilder {
        private List<CityConsumerDTO> cityConsumerDTOList;
        private String provinceName;
        private String code;

        ProvinceConsumerDTOBuilder() {
        }

        public ProvinceConsumerDTOBuilder cityConsumerDTOList(List<CityConsumerDTO> cityConsumerDTOList) {
            this.cityConsumerDTOList = cityConsumerDTOList;
            return this;
        }

        public ProvinceConsumerDTOBuilder provinceName(String provinceName) {
            this.provinceName = provinceName;
            return this;
        }

        public ProvinceConsumerDTOBuilder code(String code) {
            this.code = code;
            return this;
        }

        public ProvinceConsumerDTO build() {
            return new ProvinceConsumerDTO(this.cityConsumerDTOList, this.provinceName, this.code);
        }

        public String toString() {
            return "ProvinceConsumerDTO.ProvinceConsumerDTOBuilder(cityConsumerDTOList=" + this.cityConsumerDTOList + ", provinceName=" + this.provinceName + ", code=" + this.code + ")";
        }
    }
}

