package cn.com.duiba.cloud.manage.service.api.model.enums.supplier;

/**
 * 订单支付方式
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/2/7
 */
public enum DeliOrderPayTypeEnum {
    /** 支付方式 1-月结 2-在线支付 3-货到付款 */
    MONTHLY(1, "月结"),
    ONLINE(2, "在线支付"),
    CASH_ON_DELIVERY(3, "货到付款"),
            ;
    private Integer code;
    private String desc;

    DeliOrderPayTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
