package cn.com.duiba.cloud.manage.service.api.model.param.supplier;

import cn.com.duiba.cloud.manage.service.api.model.enums.supplier.DeliOrderInvoiceStateEnum;
import cn.com.duiba.cloud.manage.service.api.model.enums.supplier.DeliOrderInvoiceTitleTypeEnum;
import cn.com.duiba.cloud.manage.service.api.model.enums.supplier.DeliOrderInvoiceTypeEnum;
import cn.com.duiba.cloud.manage.service.api.model.enums.supplier.DeliOrderIsEmergencyEnum;
import cn.com.duiba.cloud.manage.service.api.model.enums.supplier.DeliOrderPayTypeEnum;
import cn.com.duiba.cloud.manage.service.api.model.enums.supplier.DeliOrderStatusEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 订单提交
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/2/7
 */
@Getter
@Setter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RemoteDeliOrderSubmitParam implements Serializable {

    private static final long serialVersionUID = -5940603700524605678L;
    /**
     * 平台订单号，不超过32 位长度的字符串。
     */
    @NotBlank(message = "订单号不能为空")
    private String pxOrderId;

    /**
     * 收货人
     */
    @NotBlank(message = "收货人不能为空")
    private String name;

    /**
     * 一级地址
     */
    @NotBlank(message = "一级地址不能为空")
    private String firstAddress;

    /**
     * 二级地址
     */
    @NotBlank(message = "二级地址不能为空")
    private String secondAddress;

    /**
     * 三级地址
     */
    @NotBlank(message = "三级地址不能为空")
    private String thirdAddress;

    /**
     * 详细地址
     */
    @NotBlank(message = "详细地址不能为空")
    private String address;

    /**
     * 邮编
     */
    private String zip;

    /**
     * 收货人手机号
     */
    @NotBlank(message = "收货人手机号不能为空")
    private String mobile;

    /**
     * 收货人座机号
     */
    private String phone;

    /**
     * 收货人邮箱
     */
    private String email;

    /**
     * 备注
     */
    private String remark;

    /**
     * 公司名称(发票抬头)
     */
    @NotBlank(message = "公司名称(发票抬头)不能为空")
    private String companyName;

    /**
     * 支付方式 1-月结 2-在线支付 3-货到付款
     * @see DeliOrderPayTypeEnum
     */
    @NotNull(message = "请选择一种支付方式")
    private Integer payType;

    /**
     * 订单含税总金额，不含运费
     */
    @NotNull(message = "订单含税总金额不能为空")
    private Double orderPrice;

    /**
     * 订单不含税总金额
     */
    @NotNull(message = "订单不含税总金额不能为空")
    private Double orderNakedPrice;

    /**
     * 订单税额
     */
    @NotNull(message = "订单税额不能为空")
    private Double orderTaxPrice;

    /**
     * 订单状态 1-预占单 2-即时单
     * @see DeliOrderStatusEnum
     */
    @NotNull(message = "请选择一种订单状态")
    private Integer orderStatus;

    /**
     * 发票类型 1-增值税普票 2-增值税专票
     * @see DeliOrderInvoiceTypeEnum
     */
    @NotNull(message = "请选择一种发票类型")
    private Integer invoiceType;

    /**
     * 开票方式 1-随货开票 2-集中开票
     * @see DeliOrderInvoiceStateEnum
     */
    @NotNull(message = "请选择一种开票方式")
    private Integer invoiceState;

    /**
     * 发票抬头类型：1-个人 2-企业
     * @see DeliOrderInvoiceTitleTypeEnum
     */
    @NotNull(message = "请选择一种发票抬头类型")
    private Integer invoiceTitleType;

    /**
     * 发票抬头，增值税专票时必填
     */
    private String invoiceTitle;

    /**
     * 纳税人识别号，增值税专票时必填
     */
    private String invoiceIdNo;

    /**
     * 开户银行，增值税专票时必填
     */
    private String invoiceBankName;

    /**
     * 银行账号，增值税专票时必填
     */
    private String invoiceBankNo;

    /**
     * 联系地址，增值税专票时必填
     */
    private String invoiceAddress;

    /**
     * 联系电话，增值税专票时必填
     */
    private String invoiceTelephone;

    /**
     * 发票内容如：明细、电脑配件、耗材、办公 用品等
     */
    private String invoiceContent;

    /**
     * 订单明细
     */
    @NotEmpty(message = "订单明细不能为空")
    private List<RemoteDeliOrderDetailParam> orderDetails;

    /**
     * 运费
     */
    private Integer freight;

    /**
     * 是否紧急订单 0-普通订单 1-紧急订单
     * @see DeliOrderIsEmergencyEnum
     */
    private String isEmergency;

}
