package cn.com.duiba.cloud.manage.service.api.model.dto.report.businessReport;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RegionConsumerDTO implements Serializable {

    private static final long serialVersionUID = 606446136736126832L;
    private String regionName;
    /**
     * 目标关注量
     */
    private Long followingCountTarget;
    /**
     * 目标新增量
     */
    private Long followingIncreaseCountTarget;

    /**
     * 关注量
     */
    private Long followingCount;

    /**
     * 注册零售户
     */
    private Long registerCount;

    /**
     * 消费者留存量
     */
    private Long consumerCount;

    /**
     * 第一个进度
     */
    private BigDecimal progress;
    private String progressStr;

    /**
     * 新增量
     */
    private Long increaseCount;


    /**
     * 第二个进度
     */
    private BigDecimal secondProgress;
    private String secondProgressStr;

    /**
     * 大区下身份数据
     */
    private List<ProvinceConsumerDTO> provinceConsumerDTOList;


    /**
     * 汇总数据
     */
    public void summary() {
        if (CollectionUtils.isEmpty(provinceConsumerDTOList)) {
            return;
        }
        followingCount = followingCount == null ? 0L : followingCount;
        registerCount = registerCount == null ? 0L : registerCount;
        increaseCount = increaseCount == null ? 0L : increaseCount;
        consumerCount = consumerCount == null ? 0L : consumerCount;
        for (ProvinceConsumerDTO provinceConsumerDTO : provinceConsumerDTOList) {
            followingCount =add(followingCount,provinceConsumerDTO.getFollowingCount());
            registerCount = add(registerCount,provinceConsumerDTO.getRegisterCount());
            increaseCount = add(increaseCount,provinceConsumerDTO.getIncreaseCount());
            consumerCount = add(consumerCount,provinceConsumerDTO.getConsumerCount());
        }
    }

    /**
     * 计算进度
     */
    @SuppressWarnings("all")
    public void calculateSchedule() {
        // 进度（第一个） 关注量÷目标关注量
        if (followingCount == null || followingCount == 0L) {
            this.setSecondProgress(new BigDecimal(0L).setScale(2, BigDecimal.ROUND_HALF_UP));
        } else {
            if (followingCountTarget == null || followingCountTarget == 0L) {
                this.setProgress(new BigDecimal(0L).setScale(2, BigDecimal.ROUND_HALF_UP));
            }else{
                this.setProgress(new BigDecimal(followingCount).multiply(new BigDecimal(100))
                                     .divide(new BigDecimal(followingCountTarget),2,
                                         BigDecimal.ROUND_HALF_DOWN)
                                     .setScale(2, BigDecimal.ROUND_HALF_UP));
            }
        }
        //进度第二个 新增量÷目标新增量（净增量）
        if (increaseCount == null || increaseCount == 0) {
            this.setSecondProgress(new BigDecimal(0).setScale(2, BigDecimal.ROUND_HALF_UP));
        } else {
            if (followingIncreaseCountTarget == null || followingIncreaseCountTarget == 0L) {
                this.setSecondProgress(new BigDecimal(0L).setScale(2, BigDecimal.ROUND_HALF_UP));
            }else{
                this.setSecondProgress(new BigDecimal(increaseCount).multiply(new BigDecimal(100))
                                           .divide(new BigDecimal(followingIncreaseCountTarget),2,
                                               BigDecimal.ROUND_HALF_DOWN)
                                           .setScale(2, BigDecimal.ROUND_HALF_UP));
            }

        }
    }


    public void setProgress(BigDecimal progress) {
        this.progress = progress;
        if(progress!=null){
            this.progressStr = progress.toString();
        }
    }

    public void setSecondProgress(BigDecimal secondProgress) {
        this.secondProgress = secondProgress;
        if(secondProgress!=null){
            this.secondProgressStr = secondProgress.toString();
        }
    }

    private Long add(Long first,Long second){
        long l = first == null ? 0L : first;
        long l1 = second == null ? 0L : second;
        return l+l1;
    }

}
