package cn.com.duiba.cloud.manage.service.api.model.dto.staff;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 角色信息DTO -> 和RoleDTO一致，考虑后续拆分模块，复制一份
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2021/11/9
 */
@Getter
@Setter
@ToString
public class RoleInfoDTO implements Serializable {

    private static final long serialVersionUID = 3718135363677076875L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 描述
     */
    private String roleDesc;

    /**
     * 是否默认 如果为默认角色，不可修改，不可删除，不可维护人员
     */
    private Integer defaulted;

    /**
     * 角色名称
     */
    private String name;

    /**
     * 企业id
     */
    private Long tenantId;
}
