package cn.com.duiba.cloud.manage.service.api.remoteservice.tag;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.tag.TagChildCountDto;
import cn.com.duiba.cloud.manage.service.api.model.dto.tag.ZYTagDto;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.RemoteAddTagParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.RemoteDelTagParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.RemoteUpdateTagListParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tag.RemoteUpdateTagParam;

import java.util.List;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/3/1
 */
@AdvancedFeignClient
public interface RemoteZYTagService {

    /**
     * 添加标签
     * @param param
     * @return
     */
    Long addTag(RemoteAddTagParam param) throws BizException;

    /**
     * 更新标签
     * @param param
     * @return
     */
    Boolean updateTag(RemoteUpdateTagParam param) throws BizException;

    /**
     * 批量更新标签
     * @param param
     * @return
     */
    Boolean updateTagList(RemoteUpdateTagListParam param) throws BizException;

    /**
     * 删除标签
     * @param param
     * @return
     */
    Boolean delTag(RemoteDelTagParam param) throws BizException;

    /**
     * 根据父类查询标签
     * @param parentIdList
     * @return
     */
    List<ZYTagDto> queryTagByParentId(List<Long> parentIdList);


    /**
     * 根据名称查询
     * @param name
     * @return
     */
    List<ZYTagDto> queryByName(String name);

    /**
     * 根据ID列表查询
     * @param idList
     * @param isDelete 能否查看被删除的
     * @return
     */
    List<ZYTagDto> queryByIdList(List<Long> idList,Boolean isDelete);

    /**
     * 标签id数
     * @param idList
     * @return
     */
    List<TagChildCountDto> childCount(List<Long> idList);

}
