package cn.com.duiba.cloud.manage.service.api.remoteservice.wechat;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.wechat.WechatMaterialDto;
import cn.com.duiba.cloud.manage.service.api.model.param.wechat.RemoteWechatMaterialPreviewParam;
import cn.com.duiba.cloud.manage.service.api.model.param.wechat.RemoteWechatMaterialQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/1/11
 */
@AdvancedFeignClient
public interface RemoteWechatMaterialService {

    /**
     * 同步素材
     * @param type 1、图片
     * @return
     */
    void sync(Integer type);

    /**
     * 查询素材列表
     * @param param
     * @return
     */
    PageResponse<WechatMaterialDto> getMaterialList(RemoteWechatMaterialQueryParam param);

    /**
     * 素材预览
     * @param param
     * @return
     */
    String materialPreview(RemoteWechatMaterialPreviewParam param) throws BizException;

}
