package cn.com.duiba.cloud.manage.service.api.model.enums.report;

import com.google.common.collect.ImmutableMap;
import lombok.Getter;

import java.util.Objects;

/**
 * @author xuanhongjian
 */
@Getter
public enum BusinessFirstEnum {
    /**
     * 业务一部地区
     * 杭州
     * 宁波
     * 温州
     * 嘉兴
     * 湖州
     * 金华
     * 绍兴
     * 衢州
     * 丽水
     * 台州
     * 舟山
     */
    HANGZHOU("杭州市", "330100", 1),
    NINGBO("宁波市", "330200", 2),
    WENZHOU("温州市", "330300", 3),
    JIAXING("嘉兴市", "330400", 4),
    HUZHOU("湖州市", "330500", 5),
    JINHUA("金华市", "330700", 6),
    SHAOXING("绍兴市", "330600", 7),
    QUZHOU("衢州市", "330800", 8),
    LISHUI("丽水市", "331100", 9),
    TAIZHOU("台州市", "331000", 10),
    ZHOUSHAN("舟山市", "330900", 11),

    ;
    private final String name;
    private final String areaCode;
    private final Integer code;

    BusinessFirstEnum(String name, String areaCode, Integer code) {
        this.name = name;
        this.code = code;
        this.areaCode = areaCode;
    }

    private static final ImmutableMap<String, BusinessFirstEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<String, BusinessFirstEnum> builder = ImmutableMap.builder();
        for (BusinessFirstEnum item : BusinessFirstEnum.values()) {
            builder = builder.put(item.getName(), item);
        }
        INNER_MAP = builder.build();
    }

    public static BusinessFirstEnum getByCode(String regionName) {
        return Objects.isNull(regionName) ? null : INNER_MAP.get(regionName);
    }

}
