package cn.com.duiba.cloud.manage.service.api.model.param.cheatCenter;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 功能描述：撞库明细请求数据
 *
 * @Auther: xiaotian
 * @Date: 2022/6/9 09:43
 * @Description:
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemoteCheatLogParam extends PageRequest {
    private static final long serialVersionUID = -164646533842809633L;

    /**
     * 开始时间
     */
    private Date start;

    /**
     * 结束时间
     */
    private Date end;

    /**
     * openId
     */
    private String openId;

    /**
     * 客户类型 1：消费者 2：零售户
     */
    private Integer userType;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * 用户手机号
     */
    private String phoneNum;

    /**
     * 省份编码
     */
    private String provinceCode;

    /**
     * 市编码
     */
    private String cityCode;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 撞库类型 1：黑名单 2：灰名单
     */
    private Integer cheatType;

}
