package cn.com.duiba.cloud.manage.service.api.model.param.sso;

import cn.com.duiba.cloud.manage.service.api.model.constant.RegexpConst;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * 更新用户手机号
 *
 * @author xuanhongjian
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class UpdatePhoneParams {

    /**
     * 原手机号短信唯一ID
     */
    @NotNull(message = "原手机号短信唯一ID不能为空")
    private String oldSmsKey;

    /**
     * 新手机号
     */
    @Pattern(regexp = RegexpConst.PHONE, message = "新手机号格式不正确")
    private String newPhone;

    /**
     * 新手机号短信唯一ID
     */
    @NotNull(message = "新手机号短信唯一ID不能为空")
    private String newSmsKey;

    @NotNull(message = "验证码不能为空")
    private String verifyCode;

}
