package cn.com.duiba.cloud.manage.service.api.model.enums.exportrecord;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author linzhou
 * @ClassName ImportDataTypeEnum.java
 * @createTime 2021年11月03日 19:40:00
 * @Description
 */
@Getter
@AllArgsConstructor
public enum ExportDataTypeEnum implements IEnum<Integer> {

    /**
     *
     */
    STAFF_INVITE(1,"员工导出"),
    ROLE_STAFF_INVITE(2,"角色员工导出"),
    ORDER_EXPORT(3, "订单导出"),
    EMS_DELIVER_GOODS_EXPORT(4, "ems发货列表导出"),
    DATA_REPORT_EXPORT(5,"数据报表导出"),
    TEMPLATE_PUSH_RECORD(6,"模版消息推送导出"),
    STATISTICS_PAGE_EXPORT(7,"统计页面数据导出"),
    STATISTICS_UNIT_EXPORT(8,"统计组件数据导出"),
    ACTIVITY_POINT(9,"活动积分详情导出"),
    ACTIVITY_USER_POINT_RECORD(10,"活动个人积分记录"),
    ACTIVITY_USER_PRIZE(11,"活动个人获奖记录"),
    SELF_QRCODE(12, "自建二维码导出记录"),
    SCAN_DATA(13, "自建二维码扫码数据"),
    WECHAT_DATA_DETAIL(14, "微信二维码数据明细记录"),
    WECHAT_QRCODE(15, "微信二维码导出记录"),
    RETAILER_ENTER(16,"零售户入网"),
    SALE_DISTINGUISH_RECORD(17,"零售证识别记录"),
    PEACE_REMAIN_RECORD(18,"平和星余额"),
    TIME_USER_VIEW_RECORD(19,"用户时段独立访问记录"),
    ACTIVITY_JOIN_REPORT(20,"心中远方参与报表"),
    ACTIVITY_TASK_REPORT(21,"心中远方任务报表"),
    ACTIVITY_PRIZE_REPORT(22,"心中远方奖品报表"),

    ACTIVITY_USER_POINT_CITY(23, "用户省市报表"),


    ;

    private final Integer type;
    private final String desc;

    public static ExportDataTypeEnum getExportDataTypeEnum(Integer type){
        for (ExportDataTypeEnum value : ExportDataTypeEnum.values()) {
            if (Objects.equals(value.getType(),type)){
                return value;
            }
        }
        return null;
    }

    @Override
    public Integer getDbCode() {
        return type;
    }
}
